/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.marvel.drstrange;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.reference.FlowReference;
import org.mule.runtime.extension.api.annotation.param.stereotype.ComponentId;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.test.marvel.drstrange.CustomErrorException;
import org.mule.test.marvel.drstrange.CustomErrorProvider;
import org.mule.test.marvel.drstrange.DrStrange;
import org.mule.test.marvel.drstrange.DrStrangeErrorTypeDefinition;
import org.mule.test.marvel.drstrange.MysticConnection;
import org.mule.test.marvel.drstrange.ReferableOperationStereotypeDefinition;

public class DrStrangeOperations {
    @Inject
    private ConfigurationComponentLocator locator;

    @MediaType(value="text/plain")
    public String seekStream(@Connection MysticConnection connection, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") InputStream stream, int position) throws IOException {
        Preconditions.checkArgument((boolean)(stream instanceof CursorStream), (String)"Stream was not cursored");
        CursorStream cursor = (CursorStream)stream;
        cursor.seek((long)position);
        return this.readStream(connection, (InputStream)cursor);
    }

    @Throws(value={CustomErrorProvider.class})
    @MediaType(value="text/plain")
    public String readStream(@Connection MysticConnection connection, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") InputStream stream) throws IOException {
        try {
            return IOUtils.toString((InputStream)stream);
        }
        catch (Exception e) {
            throw new CustomErrorException(e, DrStrangeErrorTypeDefinition.CUSTOM_ERROR);
        }
    }

    @MediaType(value="text/plain")
    public InputStream toStream(@Connection MysticConnection connection, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") String data) {
        return connection.manage(new ByteArrayInputStream(data.getBytes()));
    }

    public void crashCar(@Config DrStrange dr) {
        throw new RuntimeException();
    }

    @Stereotype(value=ReferableOperationStereotypeDefinition.class)
    public void withFlowReference(@Config DrStrange dr, @org.mule.runtime.extension.api.annotation.param.Optional @FlowReference String flowRef, @ComponentId String name) {
        if (!StringUtils.isBlank((String)flowRef) && !this.locator.find(Location.builder().globalName(flowRef).build()).isPresent()) {
            throw new IllegalArgumentException("The referenced flow does not exist in this application");
        }
    }

    public List<String> readObjectStream(@Content Iterator<String> iteratorValues) {
        LinkedList<String> objects = new LinkedList<String>();
        while (iteratorValues.hasNext()) {
            objects.add(iteratorValues.next());
        }
        return objects;
    }

    public PagingProvider<MysticConnection, String> sayMagicWords(final @Content List<String> values, final int fetchSize) {
        final AtomicInteger index = new AtomicInteger(0);
        return new PagingProvider<MysticConnection, String>(){
            private int timesClosed = 0;

            public List<String> getPage(MysticConnection connection) {
                int i = index.get();
                if (i >= values.size()) {
                    return Collections.emptyList();
                }
                List<String> words = values.subList(i, i + fetchSize);
                index.addAndGet(fetchSize);
                return words;
            }

            public Optional<Integer> getTotalResults(MysticConnection connection) {
                return Optional.of(values.size());
            }

            public void close(MysticConnection connection) throws MuleException {
                ++this.timesClosed;
                if (this.timesClosed > 1) {
                    throw new RuntimeException("Expected to be closed only once but was called twice");
                }
            }
        };
    }
}

