/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.marvel.drstrange;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.test.marvel.drstrange.CustomErrorException;
import org.mule.test.marvel.drstrange.CustomErrorProvider;
import org.mule.test.marvel.drstrange.DrStrange;
import org.mule.test.marvel.drstrange.DrStrangeErrorTypeDefinition;
import org.mule.test.marvel.drstrange.MysticConnection;

public class DrStrangeOperations {
    public String seekStream(@Config DrStrange dr, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") InputStream stream, int position) throws IOException {
        Preconditions.checkArgument((boolean)(stream instanceof CursorStream), (String)"Stream was not cursored");
        CursorStream cursor = (CursorStream)stream;
        cursor.seek((long)position);
        return this.readStream(dr, (InputStream)cursor);
    }

    @Throws(value={CustomErrorProvider.class})
    public String readStream(@Config DrStrange dr, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") InputStream stream) throws IOException {
        try {
            return IOUtils.toString((InputStream)stream);
        }
        catch (Exception e) {
            throw new CustomErrorException(e, DrStrangeErrorTypeDefinition.CUSTOM_ERROR);
        }
    }

    public InputStream toStream(@Config DrStrange dr, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") String data) {
        return new ByteArrayInputStream(data.getBytes());
    }

    public void crashCar(@Config DrStrange dr) {
        throw new RuntimeException();
    }

    public List<String> readObjectStream(@Content Iterator<String> iteratorValues) {
        LinkedList<String> objects = new LinkedList<String>();
        while (iteratorValues.hasNext()) {
            objects.add(iteratorValues.next());
        }
        return objects;
    }

    public PagingProvider<MysticConnection, String> sayMagicWords(final @Content List<String> values, final int fetchSize, @Connection MysticConnection connection) {
        final AtomicInteger index = new AtomicInteger(0);
        return new PagingProvider<MysticConnection, String>(){

            public List<String> getPage(MysticConnection connection) {
                int i = index.get();
                if (i >= values.size()) {
                    return Collections.emptyList();
                }
                List<String> words = values.subList(i, i + fetchSize);
                index.addAndGet(fetchSize);
                return words;
            }

            public Optional<Integer> getTotalResults(MysticConnection connection) {
                return Optional.of(values.size());
            }

            public void close() throws IOException {
            }
        };
    }
}

