/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.marvel.ironman;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.meta.model.ExecutionType;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.test.marvel.ironman.IronMan;
import org.mule.test.marvel.model.Missile;
import org.mule.test.marvel.model.Villain;

public class IronManOperations
implements Initialisable,
Disposable {
    public static final int MISSILE_TRAVEL_TIME = 200;
    public static final String FLIGHT_PLAN = "Go Straight";
    private ScheduledExecutorService executorService;

    public void initialise() throws InitialisationException {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void dispose() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public void fireMissile(@Config IronMan ironMan, @Connection Missile missile, Villain at, CompletionCallback<String, NullAttributes> callback) {
        Runnable launch = () -> {
            try {
                ironMan.track(missile);
                callback.success(Result.builder().output((Object)missile.fireAt(at)).attributes((Object)NullAttributes.NULL_ATTRIBUTES).build());
            }
            catch (Exception e) {
                callback.error(e);
            }
        };
        this.executorService.schedule(launch, 200L, TimeUnit.MILLISECONDS);
    }

    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public void computeFlightPlan(@Config IronMan ironMan, CompletionCallback<Void, NullAttributes> callback) {
        Runnable launch = () -> {
            callback.success(Result.builder().build());
            ironMan.setFlightPlan(FLIGHT_PLAN);
        };
        this.executorService.schedule(launch, 200L, TimeUnit.MILLISECONDS);
    }
}

