/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.classloading.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.StringContains;

public class ClassLoadingHelper {
    public static Map<String, ClassLoader> createdClassLoaders = new HashMap<String, ClassLoader>();

    public static void addClassLoader(String element) {
        createdClassLoaders.put(element, Thread.currentThread().getContextClassLoader());
    }

    public static void verifyUsedClassLoaders(String ... phasesToExecute) {
        Map<String, ClassLoader> createdClassLoaders = ClassLoadingHelper.createdClassLoaders;
        List<ClassLoader> collect = createdClassLoaders.values().stream().distinct().collect(Collectors.toList());
        collect.forEach(ClassLoadingHelper::assertExtensionClassLoader);
        Set<String> executedPhases = createdClassLoaders.keySet();
        MatcherAssert.assertThat(executedPhases, (Matcher)CoreMatchers.is((Matcher)IsCollectionContaining.hasItems((Matcher[])((Matcher[])Arrays.stream(phasesToExecute).map(StringContains::containsString).toArray(Matcher[]::new)))));
    }

    private static void assertExtensionClassLoader(ClassLoader classLoader) {
        MatcherAssert.assertThat((Object)classLoader.toString(), (Matcher)AllOf.allOf((Matcher[])new Matcher[]{StringContains.containsString((String)"classloading-extension"), CoreMatchers.anyOf((Matcher[])new Matcher[]{StringContains.containsString((String)".TestRegionClassLoader[Region] @"), StringContains.containsString((String)"MulePluginClassLoader")})}));
    }
}

