/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.service.domain.entity.multipart.StreamedMultipartHttpEntity;

public class HttpResponseCreator {
    private static final String HEADER_CONTENT_TYPE = "Content-Type".toLowerCase();
    private static final String HEADER_CONTENT_LENGTH = "Content-Length".toLowerCase();

    public HttpResponse create(Response response, InputStream inputStream) throws IOException {
        HttpResponseBuilder responseBuilder = HttpResponse.builder();
        responseBuilder.statusCode(Integer.valueOf(response.getStatusCode()));
        responseBuilder.reasonPhrase(response.getStatusText());
        String contentType = null;
        String contentLength = null;
        if (response.hasResponseHeaders()) {
            for (Map.Entry headerEntry : response.getHeaders().entrySet()) {
                String headerName = (String)headerEntry.getKey();
                responseBuilder.addHeaders(headerName, (Collection)headerEntry.getValue());
                if (headerName.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                    contentType = response.getHeader(HEADER_CONTENT_TYPE);
                    continue;
                }
                if (!headerName.equalsIgnoreCase(HEADER_CONTENT_LENGTH)) continue;
                contentLength = response.getHeader(HEADER_CONTENT_LENGTH);
            }
        }
        responseBuilder.entity(this.createEntity(inputStream, contentType, contentLength));
        return responseBuilder.build();
    }

    private HttpEntity createEntity(InputStream stream, String contentType, String contentLength) {
        long contentLengthAsLong = -1L;
        if (contentLength != null) {
            contentLengthAsLong = Long.parseLong(contentLength);
        }
        if (contentType != null && contentType.startsWith(MediaType.MULTIPART_MIXED.getPrimaryType())) {
            if (contentLengthAsLong >= 0L) {
                return new StreamedMultipartHttpEntity(stream, contentType, contentLengthAsLong);
            }
            return new StreamedMultipartHttpEntity(stream, contentType);
        }
        if (contentLengthAsLong > 0L) {
            return new InputStreamHttpEntity(stream, contentLengthAsLong);
        }
        if (contentLengthAsLong == 0L) {
            return new EmptyHttpEntity();
        }
        return new InputStreamHttpEntity(stream);
    }
}

