/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.http.server.async;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.http.domain.message.response.HttpResponse;
import org.mule.sdk.api.http.sse.server.SseClient;
import org.mule.sdk.api.http.sse.server.SseClientConfigurer;

import java.util.function.Consumer;

/**
 * Handler for sending an HTTP response asynchronously
 *
 * @since 0.12.0
 */
@Experimental
@NoImplement
@MinMuleVersion("4.10.0")
public interface HttpResponseReadyCallback {

  /**
   * Method to send response to the client.
   *
   * @param response               HTTP response content.
   * @param responseStatusCallback callback to be called if there's a failure while sending the response or when it is
   *                               successfully sent.
   */
  void responseReady(HttpResponse response, ResponseStatusCallback responseStatusCallback);

  /**
   * Starts a response with an SSE stream and returns a {@link SseClient} to send the corresponding events.
   *
   * @param config the config for the resulting {@link SseClient}.
   * @return the {@link SseClient} to send the events.
   */
  SseClient startSseResponse(Consumer<SseClientConfigurer> config);
}
