/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.metadata.resolving;

import org.mule.metadata.api.model.MetadataType;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.metadata.MetadataContext;

/**
 * {@link StaticResolver} implementation for the {@link ParameterModel}s.
 * <p>
 * This {@link InputTypeResolver} is discarded once the extension model is built. It's not registered with the dynamic
 * {@link InputTypeResolver}s.
 *
 * @since 1.0
 */
@MinMuleVersion("4.5.0")
public abstract class InputStaticTypeResolver implements InputTypeResolver, StaticResolver {

  /**
   * {@inheritDoc}
   * <p>
   * The category name is not used for {@link StaticResolver}s since they are not registered in the extension.
   */
  @Override
  public String getCategoryName() {
    return "INPUT_" + STATIC_RESOLVER_NAME;
  }

  /**
   * This method resolves the static input type for a {@link ParameterModel} proxing to the
   * {@link StaticResolver#getStaticMetadata()} method.
   * <p>
   * The context and key are not used nor injected.
   */
  @Override
  final public MetadataType getInputMetadata(MetadataContext context, Object key) {
    return getStaticMetadata();
  }
}
