/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.metadata.resolving;

import org.mule.api.annotation.Experimental;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.metadata.ChainInputMetadataContext;

/**
 * A type resolver to specify the payload and attributes types that enter the inner chain within a scope or route.
 *
 * <b>NOTE:</b> Experimental feature. Backwards compatibility is not guaranteed.
 *
 * @since 0.9.0
 */
@MinMuleVersion("4.7.0")
@DoNotEnforceMinMuleVersion
@Experimental
public interface ChainInputTypeResolver extends NamedTypeResolver {

  /**
   * Resolves the input payload and attributes type for a scope/route inner chain
   *
   * @param context a {@link ChainInputMetadataContext}
   * @return a {@link MessageMetadataType} describing the message that will enter the inner chain
   * @throws MetadataResolvingException
   * @throws ConnectionException
   */
  MessageMetadataType getChainInputMetadataType(ChainInputMetadataContext context)
      throws MetadataResolvingException, ConnectionException;

}
