/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.loader;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.project.MavenProject;
import org.mule.extension.maven.loader.MavenDescriptorLoaderRepository;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.internal.ClasspathModuleDiscoverer;
import org.mule.runtime.container.internal.CompositeModuleDiscoverer;
import org.mule.runtime.container.internal.ContainerClassLoaderFactory;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.JreModuleDiscoverer;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.core.internal.util.JarUtils;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginClassLoaderFactory;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.RegionPluginClassLoadersFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.application.ToolingApplicationDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;
import org.mule.runtime.module.deployment.impl.internal.plugin.BundlePluginDependenciesResolver;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginExtendedDeploymentProperties;

public class MuleArtifactResourcesRegistry {
    private ToolingApplicationDescriptorFactory applicationDescriptorFactory;
    private RegionPluginClassLoadersFactory regionPluginClassLoadersFactory;
    private BundlePluginDependenciesResolver pluginDependenciesResolver;
    private ArtifactClassLoader containerArtifactClassLoader;

    public MuleArtifactResourcesRegistry(final MavenProject project, MavenClient mavenClient) {
        MavenDescriptorLoaderRepository descriptorLoaderRepository = new MavenDescriptorLoaderRepository(mavenClient);
        ModuleRepository moduleRepository = this.createModuleRepository();
        ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder = ArtifactDescriptorValidatorBuilder.builder();
        ArtifactPluginDescriptorFactory artifactPluginDescriptorFactory = new ArtifactPluginDescriptorFactory(descriptorLoaderRepository, artifactDescriptorValidatorBuilder){

            public ArtifactPluginDescriptor create(File pluginFile, Optional<Properties> deploymentProperties) {
                try {
                    Optional<byte[]> jsonDescriptorContentOptional = Optional.empty();
                    String mulePluginJsonPath = "META-INF/mule-artifact/mule-artifact.json";
                    jsonDescriptorContentOptional = this.getMuleArtifactJsonDescriptorContent(pluginFile, jsonDescriptorContentOptional, mulePluginJsonPath);
                    MulePluginModel artifactModel = jsonDescriptorContentOptional.map(jsonDescriptorContent -> (MulePluginModel)this.loadModelFromJson(new String((byte[])jsonDescriptorContent))).orElseThrow(() -> new ArtifactDescriptorCreateException(String.format("The plugin descriptor '%s' on plugin file '%s' is not present", mulePluginJsonPath, pluginFile)));
                    MulePluginModel.MulePluginModelBuilder mulePluginModelBuilder = new MulePluginModel.MulePluginModelBuilder();
                    ((MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)mulePluginModelBuilder.setName(artifactModel.getName())).setMinMuleVersion("4.1.1")).setRequiredProduct(Product.MULE)).withBundleDescriptorLoader(artifactModel.getBundleDescriptorLoader())).withClassLoaderModelDescriptorLoader(artifactModel.getClassLoaderModelLoaderDescriptor());
                    artifactModel.getLicense().ifPresent(licenseModel -> mulePluginModelBuilder.withLicenseModel().setAllowsEvaluationLicense(licenseModel.isAllowsEvaluation()).setProvider(licenseModel.getProvider()).setRequiredEntitlement((String)licenseModel.getRequiredEntitlement().orElse(null)));
                    artifactModel.getExtensionModelLoaderDescriptor().ifPresent(extensionModelDescriptorLoader -> {
                        MuleArtifactLoaderDescriptorBuilder muleArtifactLoaderDescriptorBuilder = mulePluginModelBuilder.withExtensionModelDescriber();
                        muleArtifactLoaderDescriptorBuilder.setId(extensionModelDescriptorLoader.getId());
                        extensionModelDescriptorLoader.getAttributes().entrySet().stream().forEach(entry -> muleArtifactLoaderDescriptorBuilder.addProperty((String)entry.getKey(), entry.getValue()));
                        if (pluginFile.equals(project.getArtifact().getFile()) && artifactModel.getExtensionModelLoaderDescriptor().isPresent() && "xml-based".equals(((MuleArtifactLoaderDescriptor)artifactModel.getExtensionModelLoaderDescriptor().get()).getId())) {
                            muleArtifactLoaderDescriptorBuilder.addProperty("validate-xml", (Object)true);
                        }
                    });
                    MulePluginModel pluginModel = mulePluginModelBuilder.build();
                    return (ArtifactPluginDescriptor)this.loadFromJsonDescriptor(pluginFile, (AbstractMuleArtifactModel)pluginModel, deploymentProperties);
                }
                catch (ArtifactDescriptorCreateException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new ArtifactDescriptorCreateException((Throwable)e);
                }
            }

            private Optional<byte[]> getMuleArtifactJsonDescriptorContent(File pluginFile, Optional<byte[]> jsonDescriptorContentOptional, String mulePluginJsonPath) throws IOException {
                if (pluginFile.isFile()) {
                    Preconditions.checkArgument((boolean)pluginFile.getName().endsWith(".jar"), (String)("provided file is not a plugin: " + pluginFile.getAbsolutePath()));
                    jsonDescriptorContentOptional = JarUtils.loadFileContentFrom((File)pluginFile, (String)mulePluginJsonPath);
                } else {
                    File mulePluginJsonFile = pluginFile.toPath().resolve(Paths.get("META-INF/mule-artifact", "mule-artifact.json")).toFile();
                    if (mulePluginJsonFile.exists()) {
                        jsonDescriptorContentOptional = Optional.of(FileUtils.readFileToByteArray((File)mulePluginJsonFile));
                    }
                }
                return jsonDescriptorContentOptional;
            }
        };
        ArtifactPluginDescriptorLoaderMojo artifactPluginDescriptorLoader = new ArtifactPluginDescriptorLoaderMojo(artifactPluginDescriptorFactory);
        this.applicationDescriptorFactory = new ToolingApplicationDescriptorFactory((ArtifactPluginDescriptorLoader)artifactPluginDescriptorLoader, (DescriptorLoaderRepository)descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        this.regionPluginClassLoadersFactory = new DefaultRegionPluginClassLoadersFactory((ArtifactClassLoaderFactory)new ArtifactPluginClassLoaderFactory(), moduleRepository);
        this.pluginDependenciesResolver = new BundlePluginDependenciesResolver((ArtifactDescriptorFactory)artifactPluginDescriptorFactory);
        this.containerArtifactClassLoader = this.createContainerClassLoader(this.getClass().getClassLoader(), moduleRepository);
    }

    private ModuleRepository createModuleRepository() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(new JreModuleDiscoverer());
        result.add(new ClasspathModuleDiscoverer(this.getClass().getClassLoader(), Files.createTempDir()));
        return new DefaultModuleRepository((ModuleDiscoverer)new CompositeModuleDiscoverer(result.toArray(new ModuleDiscoverer[0])));
    }

    public ArtifactClassLoader createContainerClassLoader(ClassLoader pluginClassLoader, ModuleRepository moduleRepository) {
        ArtifactClassLoader containerClassLoaderFactory = new ContainerClassLoaderFactory(moduleRepository).createContainerClassLoader(pluginClassLoader);
        return containerClassLoaderFactory;
    }

    public ToolingApplicationDescriptorFactory getApplicationDescriptorFactory() {
        return this.applicationDescriptorFactory;
    }

    public RegionPluginClassLoadersFactory getRegionPluginClassLoadersFactory() {
        return this.regionPluginClassLoadersFactory;
    }

    public BundlePluginDependenciesResolver getPluginDependenciesResolver() {
        return this.pluginDependenciesResolver;
    }

    public ArtifactClassLoader getContainerArtifactClassLoader() {
        return this.containerArtifactClassLoader;
    }

    class ArtifactPluginDescriptorLoaderMojo
    extends ArtifactPluginDescriptorLoader {
        private final ArtifactPluginDescriptorFactory artifactPluginDescriptorFactory;

        public ArtifactPluginDescriptorLoaderMojo(ArtifactPluginDescriptorFactory artifactPluginDescriptorFactory) {
            super(artifactPluginDescriptorFactory);
            this.artifactPluginDescriptorFactory = artifactPluginDescriptorFactory;
        }

        public ArtifactPluginDescriptor load(File plugin) {
            return this.artifactPluginDescriptorFactory.create(plugin, Optional.empty());
        }

        public ArtifactPluginDescriptor load(File pluginFile, BundleDescriptor pluginBundleDescriptor, ArtifactDescriptor deployableArtifactDescriptor) {
            return this.artifactPluginDescriptorFactory.create(pluginFile, Optional.of(new PluginExtendedDeploymentProperties(new Properties(), pluginBundleDescriptor, deployableArtifactDescriptor)));
        }
    }
}

