/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.span.command;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.tracer.api.context.SpanContext;
import org.mule.runtime.tracer.api.span.validation.Assertion;
import org.mule.runtime.tracer.impl.span.command.AbstractFailSafeVoidBiCommand;
import org.mule.runtime.tracer.impl.span.command.SpanMDCUtils;
import org.mule.runtime.tracer.impl.span.command.spancontext.SpanContextFromEventContextGetter;
import org.slf4j.Logger;

public class EventContextEndSpanCommand
extends AbstractFailSafeVoidBiCommand<EventContext, Assertion> {
    private final BiConsumer<EventContext, Assertion> consumer = (eventContext, assertion) -> {
        SpanContext spanContext = SpanContextFromEventContextGetter.getSpanContextFromEventContextGetter().get((EventContext)eventContext);
        if (spanContext != null) {
            spanContext.endSpan(assertion);
            if (traceIdAndSpanIdInMdc) {
                EventContextEndSpanCommand.resetOrRemoveTraceIdAndSpanIdInMDC(spanContext);
            }
        }
    };

    public static EventContextEndSpanCommand getEventContextEndSpanCommandFrom(Logger logger, String errorMessage, boolean propagateException, boolean putTraceIdAndSpanIdInMdc) {
        return new EventContextEndSpanCommand(logger, errorMessage, propagateException, putTraceIdAndSpanIdInMdc);
    }

    private EventContextEndSpanCommand(Logger logger, String errorMessage, boolean propagateExceptions, boolean traceIdAndSpanIdInMdc) {
        super(logger, errorMessage, propagateExceptions);
    }

    private static void resetOrRemoveTraceIdAndSpanIdInMDC(SpanContext spanContext) {
        Optional span = spanContext.getSpan();
        if (span.isPresent()) {
            SpanMDCUtils.setCurrentTracingInformationToMdc((Span)span.get());
        } else {
            SpanMDCUtils.removeCurrentTracingInformationFromMdc();
        }
    }

    @Override
    BiConsumer<EventContext, Assertion> getConsumer() {
        return this.consumer;
    }
}

