/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.context;

import java.util.Optional;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.tracer.api.context.SpanContext;
import org.mule.runtime.tracer.api.context.getter.DistributedTraceContextGetter;
import org.mule.runtime.tracer.api.span.error.InternalSpanError;
import org.mule.runtime.tracer.api.span.validation.Assertion;
import org.mule.runtime.tracer.api.span.validation.AssertionFailedException;
import org.mule.runtime.tracer.impl.span.DeserializedSpan;
import org.mule.runtime.tracer.impl.span.InternalSpan;

public class EventSpanContext
implements SpanContext {
    private final boolean propagateTracingExceptions;
    private InternalSpan currentSpan;

    public static EventSpanContextBuilder builder() {
        return new EventSpanContextBuilder();
    }

    private EventSpanContext(InternalSpan currentSpan, boolean propagateTracingExceptions) {
        this.currentSpan = currentSpan;
        this.propagateTracingExceptions = propagateTracingExceptions;
    }

    public SpanContext copy() {
        return new EventSpanContext(this.currentSpan, this.propagateTracingExceptions);
    }

    public void endSpan(Assertion assertion) {
        assertion.assertOnSpan((Span)this.currentSpan);
        this.currentSpan.end();
        this.currentSpan = this.resolveParentAsInternalSpan();
    }

    public void recordErrorAtSpan(InternalSpanError error) {
        this.currentSpan.addError(error);
    }

    private InternalSpan resolveParentAsInternalSpan() {
        return InternalSpan.getAsInternalSpan(this.currentSpan.getParent());
    }

    public void setSpan(Span span, Assertion assertion) throws AssertionFailedException {
        assertion.assertOnSpan((Span)this.currentSpan);
        this.currentSpan = InternalSpan.getAsInternalSpan(span);
    }

    public Optional<Span> getSpan() {
        return Optional.ofNullable(this.currentSpan);
    }

    public static final class EventSpanContextBuilder {
        private DistributedTraceContextGetter distributedTraceContextMapGetter;
        private boolean propagateTracingExceptions;
        private boolean managedChildSpan;

        private EventSpanContextBuilder() {
        }

        public EventSpanContextBuilder withGetter(DistributedTraceContextGetter distributedTraceContextMapGetter) {
            this.distributedTraceContextMapGetter = distributedTraceContextMapGetter;
            return this;
        }

        public EventSpanContextBuilder withPropagateTracingExceptions(boolean propagateTracingExceptions) {
            this.propagateTracingExceptions = propagateTracingExceptions;
            return this;
        }

        public EventSpanContextBuilder withManagedChildSpan(boolean managedChildSpan) {
            this.managedChildSpan = managedChildSpan;
            return this;
        }

        public EventSpanContext build() {
            return new EventSpanContext(DeserializedSpan.getDeserializedRootSpan(this.distributedTraceContextMapGetter, this.managedChildSpan), this.propagateTracingExceptions);
        }
    }
}

