/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.span;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.api.profiling.tracing.SpanDuration;
import org.mule.runtime.api.profiling.tracing.SpanError;
import org.mule.runtime.api.profiling.tracing.SpanIdentifier;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.api.span.error.InternalSpanError;
import org.mule.runtime.tracer.api.span.exporter.SpanExporter;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.exporter.api.SpanExporterFactory;
import org.mule.runtime.tracer.impl.clock.Clock;

public class ExportOnEndExecutionSpan
implements InternalSpan {
    public static final String SPAN_KIND = "span.kind.override";
    public static final String STATUS = "status.override";
    private final InitialSpanInfo initialSpanInfo;
    private final SpanExporter spanExporter;
    private SpanError lastError;
    private final InternalSpan parent;
    private final Long startTime;
    private Long endTime;
    private final Map<String, String> additionalAttributes = new HashMap<String, String>();

    private ExportOnEndExecutionSpan(SpanExporterFactory spanExporterFactory, InitialSpanInfo initialSpanInfo, Long startTime, InternalSpan parent) {
        this.initialSpanInfo = initialSpanInfo;
        this.startTime = startTime;
        this.parent = parent;
        this.spanExporter = spanExporterFactory.getSpanExporter((InternalSpan)this, initialSpanInfo);
    }

    public static InternalSpan createExportOnEndExecutionSpan(SpanExporterFactory spanExporterFactory, InternalSpan parentSpan, InitialSpanInfo initialSpanInfo) {
        Objects.requireNonNull(spanExporterFactory);
        Objects.requireNonNull(initialSpanInfo);
        ExportOnEndExecutionSpan exportOnEndExecutionSpan = new ExportOnEndExecutionSpan(spanExporterFactory, initialSpanInfo, Clock.getDefault().now(), parentSpan);
        return parentSpan.onChild((InternalSpan)exportOnEndExecutionSpan);
    }

    public SpanExporter getSpanExporter() {
        return this.spanExporter;
    }

    public InternalSpan onChild(InternalSpan child) {
        if (child instanceof ExportOnEndExecutionSpan) {
            this.spanExporter.updateChildSpanExporter(((ExportOnEndExecutionSpan)child).getSpanExporter());
        }
        return child;
    }

    public void updateRootName(String name) {
        this.spanExporter.setRootName(name);
    }

    public void end() {
        this.end(Clock.getDefault().now());
    }

    public void end(long endTime) {
        this.endTime = endTime;
        this.spanExporter.export();
    }

    public void addError(InternalSpanError error) {
        this.lastError = error;
        this.spanExporter.onError(error);
    }

    public void updateName(String name) {
        this.spanExporter.updateNameForExport(name);
    }

    public void forEachAttribute(BiConsumer<String, String> biConsumer) {
        this.initialSpanInfo.forEachAttribute(biConsumer);
        if (!this.additionalAttributes.isEmpty()) {
            this.additionalAttributes.forEach(biConsumer);
        }
    }

    public Map<String, String> serializeAsMap() {
        return this.spanExporter.exportedSpanAsMap();
    }

    public boolean hasErrors() {
        return this.lastError != null;
    }

    public Span getParent() {
        return this.parent;
    }

    public SpanIdentifier getIdentifier() {
        return this.getSpanExporter().getSpanIdentifier();
    }

    public String getName() {
        return this.initialSpanInfo.getName();
    }

    public SpanDuration getDuration() {
        return new DefaultSpanDuration(this.startTime, this.endTime);
    }

    public List<SpanError> getErrors() {
        if (this.lastError != null) {
            return Collections.singletonList(this.lastError);
        }
        return Collections.emptyList();
    }

    public int getAttributesCount() {
        return this.initialSpanInfo.getInitialAttributesCount() + this.additionalAttributes.size();
    }

    public void setRootAttribute(String rootAttributeKey, String rootAttributeValue) {
        this.spanExporter.setRootAttribute(rootAttributeKey, rootAttributeValue);
    }

    public void addAttribute(String key, String value) {
        if (!(key.equals(SPAN_KIND) || key.equals(STATUS) || this.initialSpanInfo.isPolicySpan())) {
            this.additionalAttributes.put(key, value);
        }
        this.spanExporter.onAdditionalAttribute(key, value);
    }

    private static class DefaultSpanDuration
    implements SpanDuration {
        private final Long startTime;
        private final Long endTime;

        public DefaultSpanDuration(Long startTime, Long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public Long getStart() {
            return this.startTime;
        }

        public Long getEnd() {
            return this.endTime;
        }
    }
}

