/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.span.command;

import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.impl.SafeExecutionUtils;
import org.slf4j.Logger;

public class FailsafeSpanCommand {
    private final boolean propagateExceptions;
    private final Logger customLogger;
    private final String errorMessage;

    public static FailsafeSpanCommand getFailsafeSpanCommand(Logger customLogger, String errorMessage, boolean propagateExceptions) {
        return new FailsafeSpanCommand(customLogger, errorMessage, propagateExceptions);
    }

    private FailsafeSpanCommand(Logger customLogger, String errorMessage, boolean propagateExceptions) {
        this.customLogger = customLogger;
        this.errorMessage = errorMessage;
        this.propagateExceptions = propagateExceptions;
    }

    public Optional<InternalSpan> execute(Supplier<Optional<InternalSpan>> internalSpanSupplier) {
        return SafeExecutionUtils.safeExecuteWithDefaultOnThrowable(internalSpanSupplier, Optional.empty(), this.errorMessage, this.propagateExceptions, this.customLogger);
    }

    public void execute(Runnable runnable) {
        SafeExecutionUtils.safeExecute(runnable, this.errorMessage, this.propagateExceptions, this.customLogger);
    }
}

