/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.span.command;

import java.util.function.Supplier;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.tracer.api.context.SpanContextAware;
import org.mule.runtime.tracer.api.span.error.InternalSpanError;
import org.mule.runtime.tracer.impl.span.command.AbstractFailsafeSpanVoidCommand;
import org.mule.runtime.tracer.impl.span.command.VoidCommand;
import org.mule.runtime.tracer.impl.span.error.DefaultSpanError;

public class EventContextRecordErrorCommand
extends AbstractFailsafeSpanVoidCommand {
    public static final String ERROR_MESSAGE = "Error recording a span error";
    private final EventContext eventContext;
    private final Supplier<Error> spanErrorSupplier;
    private final boolean isErrorEscapingCurrentSpan;
    private final FlowCallStack flowCallStack;

    public static VoidCommand getEventContextRecordErrorCommand(EventContext eventContext, Supplier<Error> spanErrorSupplier, boolean isErrorEscapingCurrentSpan, FlowCallStack flowCallStack) {
        return new EventContextRecordErrorCommand(eventContext, spanErrorSupplier, isErrorEscapingCurrentSpan, flowCallStack);
    }

    public EventContextRecordErrorCommand(EventContext eventContext, Supplier<Error> spanErrorSupplier, boolean isErrorEscapingCurrentSpan, FlowCallStack flowCallStack) {
        this.eventContext = eventContext;
        this.spanErrorSupplier = spanErrorSupplier;
        this.isErrorEscapingCurrentSpan = isErrorEscapingCurrentSpan;
        this.flowCallStack = flowCallStack;
    }

    @Override
    protected Runnable getRunnable() {
        return () -> {
            if (this.eventContext instanceof SpanContextAware) {
                ((SpanContextAware)this.eventContext).getSpanContext().recordErrorAtSpan((InternalSpanError)new DefaultSpanError(this.spanErrorSupplier.get(), this.flowCallStack, this.isErrorEscapingCurrentSpan));
            }
        };
    }

    @Override
    protected String getErrorMessage() {
        return ERROR_MESSAGE;
    }
}

