/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.tracer.api.EventTracer;
import org.mule.runtime.tracer.api.context.getter.DistributedTraceContextGetter;
import org.mule.runtime.tracer.api.sniffer.SpanSnifferManager;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.api.span.validation.Assertion;
import org.mule.runtime.tracer.impl.span.command.EventContextAddAttributeCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextAddAttributesCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextEndSpanCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextGetDistributedTraceContextMapCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextInjectDistributedTraceContextCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextRecordErrorCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextSetCurrentSpanNameCommand;
import org.mule.runtime.tracer.impl.span.command.EventContextStartSpanCommand;
import org.mule.runtime.tracer.impl.span.factory.EventSpanFactory;

public class CoreEventTracer
implements EventTracer<CoreEvent> {
    @Inject
    private EventSpanFactory eventSpanFactory;

    public Optional<InternalSpan> startComponentSpan(CoreEvent coreEvent, InitialSpanInfo spanCustomizationInfo) {
        return this.startComponentSpan(coreEvent, spanCustomizationInfo, Assertion.SUCCESSFUL_ASSERTION);
    }

    public Optional<InternalSpan> startComponentSpan(CoreEvent coreEvent, InitialSpanInfo initialSpanInfo, Assertion assertion) {
        return EventContextStartSpanCommand.getEventContextStartSpanCommandFrom(coreEvent.getContext(), this.eventSpanFactory, initialSpanInfo, assertion).execute();
    }

    public void endCurrentSpan(CoreEvent coreEvent) {
        this.endCurrentSpan(coreEvent, Assertion.SUCCESSFUL_ASSERTION);
    }

    public void endCurrentSpan(CoreEvent coreEvent, Assertion condition) {
        EventContextEndSpanCommand.getEventContextEndSpanCommandFrom(coreEvent.getContext(), Assertion.SUCCESSFUL_ASSERTION).execute();
    }

    public void injectDistributedTraceContext(EventContext eventContext, DistributedTraceContextGetter distributedTraceContextGetter) {
        EventContextInjectDistributedTraceContextCommand.getEventContextInjectDistributedTraceContextCommand(eventContext, distributedTraceContextGetter).execute();
    }

    public void recordErrorAtCurrentSpan(CoreEvent coreEvent, Supplier<Error> errorSupplier, boolean isErrorEscapingCurrentSpan) {
        EventContextRecordErrorCommand.getEventContextRecordErrorCommand(coreEvent.getContext(), errorSupplier, isErrorEscapingCurrentSpan, coreEvent.getFlowCallStack()).execute();
    }

    public void setCurrentSpanName(CoreEvent coreEvent, String name) {
        EventContextSetCurrentSpanNameCommand.getEventContextSetCurrentSpanNameCommand(coreEvent.getContext(), name).execute();
    }

    public void addCurrentSpanAttribute(CoreEvent coreEvent, String key, String value) {
        EventContextAddAttributeCommand.getEventContextAddSpanAttributeCommandFrom(coreEvent.getContext(), key, value).execute();
    }

    public void addCurrentSpanAttributes(CoreEvent coreEvent, Map<String, String> attributes) {
        EventContextAddAttributesCommand.getEventContextAddSpanAttributesCommandFrom(coreEvent.getContext(), attributes).execute();
    }

    public SpanSnifferManager getSpanExporterManager() {
        return this.eventSpanFactory.getSpanSnifferManager();
    }

    public Map<String, String> getDistributedTraceContextMap(CoreEvent event) {
        return EventContextGetDistributedTraceContextMapCommand.getEventContextGetDistributedTraceContextMapCommand(event.getContext()).execute();
    }
}

