/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.clock;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.tracer.impl.clock.Clock;

public class SystemNanoTimeClock
implements Clock {
    private static final Clock INSTANCE = new SystemNanoTimeClock();
    private final long epochNanos = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    private final long nanoTime = System.nanoTime();

    public static Clock getInstance() {
        return INSTANCE;
    }

    private SystemNanoTimeClock() {
    }

    @Override
    public long now() {
        long deltaNanos = System.nanoTime() - this.nanoTime;
        return this.epochNanos + deltaNanos;
    }
}

