/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl.optel.config;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.ast.api.exception.PropertyNotFoundException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryAutoConfigurableSpanExporterConfiguration
implements ObservabilitySignalConfiguration,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetryAutoConfigurableSpanExporterConfiguration.class);
    public static final String DEFAULT_BACKOFF_MULTIPLIER = "1.5";
    public static final String DEFAULT_INITIAL_BACKOFF = "1";
    public static final String DEFAULT_MAXIMUM_BACKOFF = "5";
    public static final String DEFAULT_BACKOFF_MAX_ATTEMPTS = "5";
    public static final String GRPC_EXPORTER_TYPE = "GRPC";
    public static final String DEFAULT_EXPORTER_TYPE = "GRPC";
    public static final String DEFAULT_GRPC_EXPORTER_ENDPOINT = "http://localhost:4317";
    public static final String DEFAULT_HTTP_EXPORTER_ENDPOINT = "http://localhost:4318/v1/traces";
    public static final String DEFAULT_EXPORTER_TIMEOUT = "10000";
    public static final String DEFAULT_STATISTICS_LOG_FREQUENCY = "30000";
    public static final String DEFAULT_BATCH_QUEUE_SIZE = "2048";
    public static final String DEFAULT_MAX_BATCH_SIZE = "512";
    public static final String DEFAULT_SCHEDULED_DELAY = "5000";
    public static final String DEFAULT_SERVICE_NAMESPACE = "mule";
    private static final String DEFAULT_SAMPLER = "parentbased_traceidratio";
    private static final String DEFAULT_SAMPLER_ARG = "0.1";
    public static final String DEFAULT_BATCH_BACKPRESSURE_STRATEGY = "DROP";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private final ObservabilitySignalConfiguration delegate;
    private final Map<String, String> defaultConfigurationValues = new HashMap<String, String>();
    private final List<Runnable> runnablesOnChange = Collections.synchronizedList(new ArrayList());
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);

    @Inject
    public OpenTelemetryAutoConfigurableSpanExporterConfiguration(@Named(value="_muleFileSpanExporterConfiguration") ObservabilitySignalConfiguration delegate) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
    }

    public String getStringValue(String key) {
        try {
            return this.delegate.getStringValue(key, this.defaultConfigurationValues.get(key));
        }
        catch (PropertyNotFoundException e) {
            return this.defaultConfigurationValues.get(key);
        }
    }

    private void initialiseDefaultConfigurationValues() {
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.enabled", FALSE);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.type", "GRPC");
        if (this.getStringValue("mule.openTelemetry.tracer.exporter.type").equals("GRPC")) {
            this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.endpoint", DEFAULT_GRPC_EXPORTER_ENDPOINT);
        } else {
            this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.endpoint", DEFAULT_HTTP_EXPORTER_ENDPOINT);
        }
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.timeout", DEFAULT_EXPORTER_TIMEOUT);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.backoff.multiplier", DEFAULT_BACKOFF_MULTIPLIER);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.backoff.initial", DEFAULT_INITIAL_BACKOFF);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.backoff.maximum", "5");
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.backoff.maxAttempts", "5");
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.metricsLogFrequency", DEFAULT_STATISTICS_LOG_FREQUENCY);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.batch.maxSize", DEFAULT_MAX_BATCH_SIZE);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.batch.queueSize", DEFAULT_BATCH_QUEUE_SIZE);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.batch.scheduledDelay", DEFAULT_SCHEDULED_DELAY);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.sampler.type", DEFAULT_SAMPLER);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.sampler.arg", DEFAULT_SAMPLER_ARG);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.resource.service.namespace", DEFAULT_SERVICE_NAMESPACE);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.batch.backPressure.strategy", DEFAULT_BATCH_BACKPRESSURE_STRATEGY);
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.tls.certificatesStrategy", "CERTIFICATES_PATH");
        this.defaultConfigurationValues.put("mule.openTelemetry.tracer.exporter.resource.includeAnypointMetadata", TRUE);
    }

    public void doOnConfigurationChanged(Runnable doOnChange) {
        this.runnablesOnChange.add(doOnChange);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.delegate, (Logger)LOGGER);
    }

    public void initialise() throws InitialisationException {
        if (!this.isInitialized.getAndSet(true)) {
            this.delegate.doOnConfigurationChanged(() -> this.runnablesOnChange.forEach(Runnable::run));
            this.initialiseDefaultConfigurationValues();
        }
    }
}

