/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.config.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.tracer.common.watcher.TracingConfigurationFileWatcher;
import org.mule.runtime.tracer.exporter.config.api.SpanExporterConfiguration;

public class FileSpanExporterConfiguration
implements SpanExporterConfiguration,
Disposable {
    private final MuleContext muleContext;
    public static final String MULE_TRACING_CONFIGURATION_PATH = "mule.tracer.config.path";
    private final String PROPERTIES_FILE_NAME = System.getProperty("mule.tracer.config.path", "tracer-exporter.conf");
    private ConfigurationPropertiesResolver propertyResolver;
    private JsonNode configuration;
    private ClassLoaderResourceProvider resourceProvider;
    private boolean propertiesInitialised;
    private URL configurationUrl;
    private final CompositeRunnable doOnConfigurationChanged = new CompositeRunnable();
    private TracingConfigurationFileWatcher tracingConfigurationFileWatcher;
    private String resolvedConfigurationFilePath;
    private static final ObjectMapper configFileMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private boolean tracingConfigurationFileWatcherInitialised;

    public FileSpanExporterConfiguration(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public String getStringValue(String key) {
        String value;
        if (!this.propertiesInitialised) {
            this.initialiseProperties();
            this.propertiesInitialised = true;
        }
        if ((value = this.readStringFromConfigOrSystemProperty(key)) != null) {
            String absolutePath;
            value = this.propertyResolver.apply(value);
            if (this.isAValueCorrespondingToAPath(key) && (absolutePath = this.getAbsolutePath(value)) != null) {
                return absolutePath;
            }
            return value;
        }
        return null;
    }

    private String readStringFromConfigOrSystemProperty(String key) {
        if (this.configuration != null) {
            String[] path = key.split("\\.");
            JsonNode configurationValue = this.configuration;
            for (int i = 0; i < path.length && configurationValue.get(path[i]) != null; ++i) {
                configurationValue = configurationValue.get(path[i]);
            }
            return configurationValue != null && !configurationValue.asText().isEmpty() ? configurationValue.asText() : null;
        }
        return System.getProperty(key);
    }

    private String getAbsolutePath(String value) {
        Path path = Paths.get(value, new String[0]);
        try {
            URL url;
            if (!path.isAbsolute() && (url = this.getExecutionClassLoader(this.muleContext).getResource(value)) != null) {
                return new File(url.toURI()).getAbsolutePath();
            }
        }
        catch (URISyntaxException e) {
            return value;
        }
        return null;
    }

    private boolean isAValueCorrespondingToAPath(String key) {
        return key.equals("mule.openTelemetry.tracer.exporter.tls.caFileLocation") || key.equals("mule.openTelemetry.tracer.exporter.tls.keyFileLocation");
    }

    private void getSpanExporterConfigurationProperties() {
        if (Boolean.getBoolean("mule.tracing.configuration.enableTracerConfigurationAtApplicationLevel")) {
            try {
                InputStream is = this.resourceProvider.getResourceAsStream(this.getPropertiesFileName());
                this.configuration = FileSpanExporterConfiguration.loadConfiguration(is);
                this.configurationUrl = ClassUtils.getResourceOrFail((String)this.getPropertiesFileName(), (ClassLoader)this.getExecutionClassLoader(this.muleContext), (boolean)true);
            }
            catch (IOException | MuleRuntimeException is) {}
        } else {
            try {
                String resourcePath = this.resolveConfigurationFilePath();
                InputStream is = IOUtils.getResourceAsStream((String)resourcePath, FileSpanExporterConfiguration.class);
                this.configuration = FileSpanExporterConfiguration.loadConfiguration(is);
                this.configurationUrl = IOUtils.getResourceAsUrl((String)resourcePath, FileSpanExporterConfiguration.class, (boolean)true, (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String resolveConfigurationFilePath() {
        if (this.resolvedConfigurationFilePath != null) {
            return this.resolvedConfigurationFilePath;
        }
        this.resolvedConfigurationFilePath = System.getProperty("mule.openTelemetry.tracer.exporter.configurationFilePath", this.getConfFolder() + FileSystems.getDefault().getSeparator() + this.getPropertiesFileName());
        return this.resolvedConfigurationFilePath;
    }

    protected String getConfFolder() {
        return MuleFoldersUtil.getConfFolder().getAbsolutePath();
    }

    protected String getPropertiesFileName() {
        return this.PROPERTIES_FILE_NAME;
    }

    private static JsonNode loadConfiguration(InputStream is) throws IOException {
        if (is == null) {
            I18nMessage error = CoreMessages.objectIsNull((String)"input stream");
            throw new IOException(error.toString());
        }
        try {
            JsonNode jsonNode = configFileMapper.readTree(is);
            return jsonNode;
        }
        finally {
            is.close();
        }
    }

    protected void initialiseProperties() {
        this.resourceProvider = new ClassLoaderResourceProvider(this.getExecutionClassLoader(this.muleContext));
        this.getSpanExporterConfigurationProperties();
        this.propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), (ConfigurationPropertiesProvider)new SystemPropertiesConfigurationProvider());
        if (this.configurationUrl != null && !this.tracingConfigurationFileWatcherInitialised) {
            this.tracingConfigurationFileWatcher = new TracingConfigurationFileWatcher(this.configurationUrl.getFile(), (Runnable)this.doOnConfigurationChanged);
            this.tracingConfigurationFileWatcher.start();
            this.tracingConfigurationFileWatcherInitialised = true;
        }
    }

    protected ClassLoader getExecutionClassLoader(MuleContext muleContext) {
        return muleContext.getExecutionClassLoader();
    }

    public void doOnConfigurationChanged(Runnable doOnConfigurationChanged) {
        this.doOnConfigurationChanged.addRunnable(doOnConfigurationChanged);
    }

    public void dispose() {
        if (this.tracingConfigurationFileWatcher != null) {
            this.tracingConfigurationFileWatcher.interrupt();
        }
    }

    private class CompositeRunnable
    implements Runnable {
        private final List<Runnable> runnables = new ArrayList<Runnable>();

        CompositeRunnable() {
            this.runnables.add(FileSpanExporterConfiguration.this::initialiseProperties);
        }

        @Override
        public void run() {
            this.runnables.forEach(Runnable::run);
        }

        public void addRunnable(Runnable runnable) {
            this.runnables.add(runnable);
        }
    }
}

