/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.config.impl;

import jakarta.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.observability.AbstractFileObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilityConfigurationFileWatcher;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSpanExporterConfiguration
extends AbstractFileObservabilitySignalConfiguration
implements ObservabilitySignalConfiguration,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(FileSpanExporterConfiguration.class);
    private static final List<String> artifactLevelConfigurationProperties = List.of("mule.openTelemetry.tracer.exporter.resource.service.name", "mule.openTelemetry.tracer.exporter.resource.service.namespace", "mule.openTelemetry.tracer.exporter.sampler.type", "mule.openTelemetry.tracer.exporter.sampler.arg", "mule.openTelemetry.tracer.exporter.tls.certificatesStrategy", "mule.openTelemetry.tracer.exporter.tls.certFileLocation", "mule.openTelemetry.tracer.exporter.tls.keyFileLocation", "mule.openTelemetry.tracer.exporter.tls.caFileLocation", "mule.openTelemetry.tracer.exporter.tls.certBase64", "mule.openTelemetry.tracer.exporter.tls.keyBase64", "mule.openTelemetry.tracer.exporter.tls.caBase64");
    private final String configurationFileName = System.getProperty("mule.openTelemetry.tracer.exporter.configurationFileName", "tracer-exporter.conf");
    private final CompositeRunnable doOnConfigurationChanged = new CompositeRunnable();
    private ObservabilityConfigurationFileWatcher tracingConfigurationFileWatcher;
    private Path resolvedConfigurationFilePath;
    private boolean tracingConfigurationFileWatcherInitialised;

    @Inject
    public FileSpanExporterConfiguration(MuleContext muleContext) {
        super(path -> FileSpanExporterConfiguration.findArtifactConfigFile((ClassLoader)muleContext.getExecutionClassLoader(), (String)path), muleContext.getDeploymentProperties(), muleContext.getId());
    }

    protected boolean isArtifactLevelProperty(String configurationKey) {
        return artifactLevelConfigurationProperties.contains(configurationKey);
    }

    protected Path getSignalConfigurationFileDirectoryPath() {
        if (this.resolvedConfigurationFilePath != null) {
            return this.resolvedConfigurationFilePath;
        }
        this.resolvedConfigurationFilePath = Paths.get(System.getProperty("mule.openTelemetry.tracer.exporter.configurationFilePath", MuleFoldersUtil.getConfFolder().getAbsolutePath()), new String[0]).toAbsolutePath();
        return this.resolvedConfigurationFilePath;
    }

    protected String getSignalConfigurationFileName() {
        return this.configurationFileName;
    }

    protected void initialise() {
        super.initialise();
        if (this.getConfigurationFile() != null && this.getConfigurationFile().exists() && !this.tracingConfigurationFileWatcherInitialised) {
            this.tracingConfigurationFileWatcher = new ObservabilityConfigurationFileWatcher(this.getConfigurationFile(), (Runnable)this.doOnConfigurationChanged);
            this.tracingConfigurationFileWatcher.start();
            this.tracingConfigurationFileWatcherInitialised = true;
        }
    }

    protected void onConfigurationFileNotFound() {
        logger.atInfo().log("Tracing exporter configuration file named '{}' not found {}. Using default configuration.", (Object)this.getSignalConfigurationFileName(), (Object)this.getConfigurationFileLocations());
    }

    protected void onConfigurationFileLoadError(Exception error, File configurationFile) {
        logger.atWarn().log("Span exporter configuration file at '{}' had a parsing error: {}. Using default configuration.", (Object)configurationFile.getAbsolutePath(), (Object)error.getMessage());
    }

    public void doOnConfigurationChanged(Runnable doOnConfigurationChanged) {
        this.doOnConfigurationChanged.addRunnable(doOnConfigurationChanged);
    }

    public void dispose() {
        if (this.tracingConfigurationFileWatcher != null) {
            this.tracingConfigurationFileWatcher.interrupt();
        }
    }

    private class CompositeRunnable
    implements Runnable {
        private final List<Runnable> runnables = new ArrayList<Runnable>();

        CompositeRunnable() {
            this.runnables.add(FileSpanExporterConfiguration.this::initialise);
        }

        @Override
        public void run() {
            this.runnables.forEach(Runnable::run);
        }

        public void addRunnable(Runnable runnable) {
            this.runnables.add(runnable);
        }
    }
}

