/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.server;

import java.util.Objects;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;

class DefaultPathAndMethodRequestMatcher
implements PathAndMethodRequestMatcher {
    private final String path;
    private final MethodRequestMatcher methodRequestMatcher;

    DefaultPathAndMethodRequestMatcher(MethodRequestMatcher methodRequestMatcher, String path) {
        this.methodRequestMatcher = methodRequestMatcher;
        this.path = this.endsWithWildcardPath(path) ? path : path + "/";
    }

    private boolean endsWithWildcardPath(String path) {
        return path.endsWith("/") || path.endsWith("*");
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public MethodRequestMatcher getMethodRequestMatcher() {
        return this.methodRequestMatcher;
    }

    @Override
    public boolean matches(HttpRequest request) {
        return this.methodRequestMatcher.matches(request);
    }

    public String toString() {
        return String.format("%s{path='%s', methodRequestMatcher='%s'}", this.getClass().getSimpleName(), this.path, this.methodRequestMatcher);
    }

    public int hashCode() {
        return Objects.hash(this.path.hashCode(), this.methodRequestMatcher.hashCode());
    }

    public boolean equals(Object obj) {
        return obj instanceof DefaultPathAndMethodRequestMatcher && Objects.equals(this.path, ((DefaultPathAndMethodRequestMatcher)obj).path) && Objects.equals(this.methodRequestMatcher, ((DefaultPathAndMethodRequestMatcher)obj).methodRequestMatcher);
    }
}

