/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.ws.exception;

import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.http.api.ws.WebSocket;

public abstract class WebSocketRuntimeException
extends MuleRuntimeException {
    protected final String webSocketId;
    protected transient WebSocket webSocket;

    public WebSocketRuntimeException(String message, WebSocket webSocket) {
        this(message, webSocket, null);
    }

    public WebSocketRuntimeException(String message, WebSocket webSocket, Throwable cause) {
        super(I18nMessageFactory.createStaticMessage((String)message), cause);
        this.webSocketId = webSocket.getId();
        this.webSocket = webSocket;
    }

    public final Optional<WebSocket> getWebSocket() {
        return Optional.ofNullable(this.webSocket);
    }

    public final String getWebSocketId() {
        return this.webSocketId;
    }
}

