/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.message;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.HttpMessage;

public abstract class HttpMessageBuilder<B extends HttpMessageBuilder, M extends HttpMessage> {
    protected MultiMap<String, String> headers;
    protected HttpEntity entity = new EmptyHttpEntity();

    public HttpMessageBuilder() {
        this.initHeaders();
    }

    protected HttpMessageBuilder(HttpMessage httpMessage) {
        this.entity(httpMessage.getEntity());
        this.initHeaders();
        this.headers(httpMessage.getHeaders());
    }

    protected void initHeaders() {
        this.headers = new CaseInsensitiveMultiMap();
    }

    public B entity(HttpEntity entity) {
        Objects.requireNonNull(entity, "entity cannot be null, use an EmptyHttpEntity instead");
        this.entity = entity;
        return (B)this;
    }

    public B headers(MultiMap<String, String> headersMap) {
        this.headers.putAll(headersMap);
        return (B)this;
    }

    public B addHeader(String name, String value) {
        this.headers.put((Object)name, (Object)value);
        return (B)this;
    }

    public B addHeaders(String name, Collection<String> values) {
        this.headers.put((Object)name, values);
        return (B)this;
    }

    public B removeHeader(String name) {
        this.headers.remove((Object)name);
        return (B)this;
    }

    public Optional<String> getHeaderValue(String name) {
        return Optional.ofNullable((String)this.headers.get((Object)name));
    }

    public Collection<String> getHeaderValues(String name) {
        return this.headers.getAll((Object)name);
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers.toImmutableMultiMap();
    }

    public abstract M build();
}

