/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.entity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.commons.io.IOUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;

@NoExtend
public class InputStreamHttpEntity
implements HttpEntity {
    private OptionalLong contentLength;
    private InputStream inputStream;

    public InputStreamHttpEntity(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "HTTP entity stream cannot be null.");
        this.inputStream = inputStream;
        this.contentLength = OptionalLong.empty();
    }

    @Deprecated
    public InputStreamHttpEntity(InputStream inputStream, Long contentLength) {
        this(inputStream);
        this.contentLength = contentLength == null ? OptionalLong.empty() : OptionalLong.of(contentLength);
    }

    public InputStreamHttpEntity(InputStream inputStream, long contentLength) {
        this(inputStream);
        this.contentLength = OptionalLong.of(contentLength);
    }

    public InputStreamHttpEntity(InputStream inputStream, OptionalLong contentLength) {
        this(inputStream);
        this.contentLength = contentLength;
    }

    @Override
    public boolean isStreaming() {
        return true;
    }

    @Override
    public boolean isComposed() {
        return false;
    }

    @Override
    public InputStream getContent() {
        return this.inputStream;
    }

    @Override
    public byte[] getBytes() throws IOException {
        return IOUtils.toByteArray((InputStream)this.inputStream);
    }

    @Override
    public Collection<HttpPart> getParts() {
        return Collections.emptyList();
    }

    @Override
    public Optional<Long> getLength() {
        return this.contentLength.isPresent() ? Optional.of(this.contentLength.getAsLong()) : Optional.empty();
    }

    @Override
    public OptionalLong getBytesLength() {
        return this.contentLength;
    }
}

