/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class ErrorHandlerOnErrorHasTypeOrWhen
implements Validation {
    private static final String ON_ERROR = "on-error";
    private static final String WHEN_CHOICE_ES_ATTRIBUTE = "when";
    private static final String TYPE_ES_ATTRIBUTE = "type";
    private static final String ERROR_HANDLER = "error-handler";
    private static final String REFERENCE_ATTRIBUTE = "ref";
    private static final ComponentIdentifier ERROR_HANDLER_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("error-handler").build();
    private static final ComponentIdentifier ON_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("on-error").build();

    public String getName() {
        return "'error-handler': 'on-error' has 'type' or 'when'";
    }

    public String getDescription() {
        return "Every handler (except for the last one) within an 'error-handler' must specify a 'when' or 'type' attribute.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return h -> {
            if (h.size() < 2) {
                return false;
            }
            ComponentAst errorHandler = (ComponentAst)h.get(h.size() - 2);
            return ComponentAstPredicatesFactory.equalsIdentifier((ComponentIdentifier)ERROR_HANDLER_IDENTIFIER).test(errorHandler) && ComponentAstPredicatesFactory.currentElemement(ehc -> errorHandler.directChildrenStream().limit(errorHandler.directChildrenStream().count() - 1L).anyMatch(comp -> comp.equals(ehc))).test(h);
        };
    }

    public Optional<ValidationResultItem> validate(ComponentAst onErrorModel, ArtifactAst artifact) {
        if (ON_ERROR_IDENTIFIER.equals(onErrorModel.getIdentifier())) {
            ComponentParameterAst errorRefParam = onErrorModel.getParameter("General", REFERENCE_ATTRIBUTE);
            Optional refAttr = errorRefParam.getValue().getValue();
            Optional referenced = refAttr.flatMap(sharedOnErrorName -> artifact.topLevelComponentsStream().filter(ComponentAstPredicatesFactory.equalsComponentId((String)sharedOnErrorName)).findAny());
            if (refAttr.isPresent() && !referenced.isPresent()) {
                return Optional.of(ValidationResultItem.create((ComponentAst)onErrorModel, (ComponentParameterAst)errorRefParam, (Validation)this, (String)String.format("Could not find 'on-error' reference named '%s'", refAttr.get())));
            }
            onErrorModel = (ComponentAst)referenced.get();
        }
        if (!this.isParameterPresent(onErrorModel, WHEN_CHOICE_ES_ATTRIBUTE) && !this.isParameterPresent(onErrorModel, TYPE_ES_ATTRIBUTE)) {
            return Optional.of(ValidationResultItem.create((ComponentAst)onErrorModel, (Validation)this, (String)"Every handler (except for the last one) within an 'error-handler' must specify a 'when' or 'type' attribute."));
        }
        return Optional.empty();
    }

    boolean isParameterPresent(ComponentAst componentAst, String name) {
        ComponentParameterAst parameterAst = componentAst.getParameter("General", name);
        if (parameterAst == null) {
            return false;
        }
        return parameterAst.getValue().getValue().isPresent();
    }
}

