/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.function.Predicate;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.config.internal.validation.SingletonsAreNotRepeated;
import org.mule.runtime.core.privileged.extension.SingletonModelProperty;

public class SingletonsPerFileAreNotRepeated
extends SingletonsAreNotRepeated {
    @Override
    public String getName() {
        return "Singletons per file are not repeated";
    }

    @Override
    public String getDescription() {
        return "Elements declared as singletons via the 'SingletonModelProperty' with 'appliesToFile' as true are not repeated in a config file.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    protected boolean isApplicable(SingletonModelProperty smp) {
        return !super.isApplicable(smp);
    }

    @Override
    protected Predicate<? super ComponentAst> additionalFilter(ComponentAst component) {
        return comp -> comp.getMetadata().getFileName().equals(component.getMetadata().getFileName());
    }
}

