/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.extension.api.declaration.type.annotation.LiteralTypeAnnotation;

public class NoExpressionsInNoExpressionsSupportedParams
implements Validation {
    private static final String FLOW_REF_ELEMENT = "flow-ref";
    private static final String DEFAULT_EXPRESSION_PREFIX = "#[";
    private static final String DEFAULT_EXPRESSION_SUFFIX = "]";
    private static final ComponentIdentifier FLOW_REF_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("flow-ref").build();

    public String getName() {
        return "No expressions in no expressionsSupported params";
    }

    public String getDescription() {
        return "No expressions are provided for parameters that do not support expressions.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(component -> component.getModel(ParameterizedModel.class).isPresent()).and(ComponentAstPredicatesFactory.currentElemement(ComponentAstPredicatesFactory.equalsIdentifier((ComponentIdentifier)FLOW_REF_IDENTIFIER).negate()));
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        for (ComponentParameterAst param : component.getParameters()) {
            if (param.getModel().isComponentId() || !param.getValue().isRight() || !(param.getValue().getRight() instanceof String)) continue;
            String stringValue = (String)param.getValue().getRight();
            if (!ExpressionSupport.NOT_SUPPORTED.equals((Object)param.getModel().getExpressionSupport()) || param.getModel().getType().getAnnotation(LiteralTypeAnnotation.class).isPresent() || !stringValue.startsWith(DEFAULT_EXPRESSION_PREFIX) || !stringValue.endsWith(DEFAULT_EXPRESSION_SUFFIX)) continue;
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)param, (Validation)this, (String)String.format("An expression value was given for parameter '%s' but it doesn't support expressions", param.getModel().getName())));
        }
        return Optional.empty();
    }
}

