/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.troubleshooting.internal.operations;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.alert.TimedDataAggregation;
import org.mule.runtime.core.api.alert.MuleAlertingSupport;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.troubleshooting.api.ArgumentDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperation;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationCallback;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultArgumentDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultTroubleshootingOperationDefinition;

public class AlertFuseboardOperation
implements TroubleshootingOperation {
    public static final String ALERT_FUSEBOARD_OPERATION_NAME = "alertFuseboard";
    public static final String ALERT_FUSEBOARD_OPERATION_DESCRIPTION = "Collects a summary of the alerts for predefined time intervals";
    public static final String APPLICATION_ARGUMENT_NAME = "application";
    public static final String APPLICATION_ARGUMENT_DESCRIPTION = "Application to collect the event dump from";
    private static final Set<String> ALERTS_WITHOUT_CONTEXT = Set.of("REACTOR_DROPPED_EVENT", "ASYNC_LOOGER_RINGBUFFER_FULL");
    private static final TroubleshootingOperationDefinition definition = AlertFuseboardOperation.createOperationDefinition();
    private final DeploymentService deploymentService;

    public AlertFuseboardOperation(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    @Override
    public TroubleshootingOperationDefinition getDefinition() {
        return definition;
    }

    @Override
    public TroubleshootingOperationCallback getCallback() {
        return (arguments, writer) -> {
            String applicationName = (String)arguments.get(APPLICATION_ARGUMENT_NAME);
            if (applicationName == null) {
                this.writeAlertFuseboardsForAllApplications(writer);
            } else {
                Application application = this.deploymentService.findApplication(applicationName);
                AlertFuseboardOperation.writeAlertFuseboardEntries(application, writer);
            }
        };
    }

    private static void writeAlertFuseboardFor(Application application, Writer writer) throws IOException {
        String appsTitle = "Alert Fuseboard for application '" + application.getArtifactName() + "'";
        writer.write(appsTitle + System.lineSeparator());
        writer.write(StringUtils.leftPad((String)"", (int)appsTitle.length(), (String)"-") + System.lineSeparator());
        writer.write(System.lineSeparator());
        AlertFuseboardOperation.writeAlertFuseboardEntries(application, writer);
    }

    private void writeAlertFuseboardsForAllApplications(Writer writer) throws IOException {
        for (Application application : this.deploymentService.getApplications()) {
            AlertFuseboardOperation.writeAlertFuseboardFor(application, writer);
        }
    }

    private static void writeAlertFuseboardEntries(Application application, Writer writer) throws IOException {
        MuleAlertingSupport muleAlertingSupport = (MuleAlertingSupport)application.getArtifactContext().getRegistry().lookupByType(MuleAlertingSupport.class).orElseThrow(() -> new IllegalArgumentException(String.format("Could not get MuleAlertingSupport for application %s.", application.getArtifactName())));
        Map alertSummary = muleAlertingSupport.alertsCountAggregation();
        if (alertSummary.isEmpty()) {
            writer.write("  No alerts triggered during the last hour.");
            writer.write(System.lineSeparator());
            return;
        }
        Map alertContexts = muleAlertingSupport.getAlertContexts();
        Optional<Integer> maxAlertNameLength = alertSummary.keySet().stream().map(String::length).max((o1, o2) -> o1 - o2);
        String formatString = "  * %-" + String.valueOf(maxAlertNameLength.orElse(30)) + "s    %3d / %3d / %4d / %4d%n";
        for (Map.Entry alertData : alertSummary.entrySet()) {
            Map contextCounts;
            String alertName = (String)alertData.getKey();
            TimedDataAggregation alertCounts = (TimedDataAggregation)alertData.getValue();
            writer.write(formatString.formatted(alertName, alertCounts.forLast1MinInterval(), alertCounts.forLast5MinsInterval(), alertCounts.forLast15MinsInterval(), alertCounts.forLast60MinsInterval()));
            if (!alertContexts.containsKey(alertName) || (contextCounts = (Map)alertContexts.get(alertName)) == null) continue;
            AlertFuseboardOperation.writeAlertContext(writer, alertName, contextCounts, (Integer)alertCounts.forLast60MinsInterval());
        }
        writer.write(System.lineSeparator());
    }

    private static void writeAlertContext(Writer writer, String alertName, Map<String, Integer> contextCounts, int totalAlerts) throws IOException {
        if (ALERTS_WITHOUT_CONTEXT.contains(alertName)) {
            return;
        }
        if (contextCounts.isEmpty()) {
            return;
        }
        String contextDescription = AlertFuseboardOperation.getContextDescription(alertName);
        writer.write("    " + contextDescription + ":" + System.lineSeparator());
        for (Map.Entry<String, Integer> entry : contextCounts.entrySet()) {
            String context = entry.getKey();
            Integer count = entry.getValue();
            if (count > 1) {
                writer.write("      - " + context + " (" + count + " times)" + System.lineSeparator());
                continue;
            }
            writer.write("      - " + context + System.lineSeparator());
        }
        int contextAlerts = contextCounts.values().stream().mapToInt(Integer::intValue).sum();
        int alertsWithoutContext = totalAlerts - contextAlerts;
        if (alertsWithoutContext > 0) {
            writer.write("      - (no context) (" + alertsWithoutContext + " times)" + System.lineSeparator());
        }
    }

    private static String getContextDescription(String alertName) {
        switch (alertName) {
            case "BACKPRESSURE_TRIGGERED": {
                return "Flow/Component that exceeded capacity";
            }
            case "REACTOR_DROPPED_ERROR": {
                return "Dropped error details";
            }
            case "MULE_UNKNOWN_ERROR_RAISED": {
                return "Error details";
            }
            case "NOT_CONSUMED_STREAM_BUSTED": {
                return "Originating location";
            }
            case "XA_RECOVERY_START_ERROR": {
                return "Resource that failed recovery";
            }
            case "REACTOR_DISCARDED_EVENT": {
                return "Event details";
            }
        }
        return "Details";
    }

    private static TroubleshootingOperationDefinition createOperationDefinition() {
        return new DefaultTroubleshootingOperationDefinition(ALERT_FUSEBOARD_OPERATION_NAME, ALERT_FUSEBOARD_OPERATION_DESCRIPTION, AlertFuseboardOperation.createApplicationArgumentDefinition());
    }

    private static ArgumentDefinition createApplicationArgumentDefinition() {
        return new DefaultArgumentDefinition(APPLICATION_ARGUMENT_NAME, APPLICATION_ARGUMENT_DESCRIPTION, false);
    }
}

