/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tls.internal.socket;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.stream.Streams;
import org.mule.runtime.core.internal.util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsProperties {
    private static final Logger logger = LoggerFactory.getLogger(TlsProperties.class);
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;
    private String defaultProtocol;

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void load(String fileName) {
        try (InputStream config = this.resolveConfigStream(fileName);){
            if (config == null) {
                logger.warn("File {} not found, using default configuration.", (Object)fileName);
            } else {
                logger.info("Loading configuration file: {}", (Object)fileName);
                Properties properties = PropertiesUtils.loadProperties((InputStream)config);
                String enabledCipherSuitesProperty = properties.getProperty("enabledCipherSuites");
                String enabledProtocolsProperty = properties.getProperty("enabledProtocols");
                String defaultProtocolProperty = properties.getProperty("defaultProtocol");
                if (enabledCipherSuitesProperty != null) {
                    this.enabledCipherSuites = (String[])Streams.of((Object[])StringUtils.split((String)enabledCipherSuitesProperty, (String)",")).map(String::trim).toArray(String[]::new);
                }
                if (enabledProtocolsProperty != null) {
                    this.enabledProtocols = (String[])Streams.of((Object[])StringUtils.split((String)enabledProtocolsProperty, (String)",")).map(String::trim).toArray(String[]::new);
                }
                if (defaultProtocolProperty != null) {
                    this.defaultProtocol = defaultProtocolProperty.trim();
                }
            }
        }
        catch (IOException e) {
            logger.atWarn().setCause((Throwable)e).log("Cannot read file {}, using default configuration", (Object)fileName);
        }
    }

    private InputStream resolveConfigStream(String fileName) {
        InputStream configStream = null;
        if (this.allowTlsConfArtifactClassLoaderLookup()) {
            configStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        }
        if (configStream == null) {
            configStream = TlsProperties.class.getClassLoader().getResourceAsStream(fileName);
        }
        return configStream;
    }

    private boolean allowTlsConfArtifactClassLoaderLookup() {
        return Boolean.getBoolean("mule.tlsConf.artifactClassloaderLookup.enable");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TlsProperties that = (TlsProperties)o;
        if (!Arrays.equals(this.enabledCipherSuites, that.enabledCipherSuites)) {
            return false;
        }
        if (!Arrays.equals(this.enabledProtocols, that.enabledProtocols)) {
            return false;
        }
        return this.defaultProtocol != null ? this.defaultProtocol.equals(that.defaultProtocol) : that.defaultProtocol == null;
    }

    public int hashCode() {
        int result = this.enabledCipherSuites != null ? Arrays.hashCode(this.enabledCipherSuites) : 0;
        result = 31 * result + (this.enabledProtocols != null ? Arrays.hashCode(this.enabledProtocols) : 0);
        result = 31 * result + (this.defaultProtocol != null ? this.defaultProtocol.hashCode() : 0);
        return result;
    }
}

