/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.config.api.ArtifactContextFactory;
import org.mule.runtime.config.internal.ComponentBuildingDefinitionRegistryFactoryAware;
import org.mule.runtime.config.internal.DefaultComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.artifact.SpringArtifactContext;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.config.internal.context.BaseMuleArtifactContext;
import org.mule.runtime.config.internal.context.MuleArtifactContext;
import org.mule.runtime.config.internal.context.lazy.LazyMuleArtifactContext;
import org.mule.runtime.config.internal.model.ComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.model.ComponentModelInitializer;
import org.mule.runtime.config.internal.registry.BaseSpringRegistry;
import org.mule.runtime.config.internal.registry.CompositeOptionalObjectsController;
import org.mule.runtime.config.internal.registry.DefaultOptionalObjectsController;
import org.mule.runtime.config.internal.registry.OptionalObjectsController;
import org.mule.runtime.config.internal.registry.SpringRegistry;
import org.mule.runtime.config.internal.resolvers.ConfigurationDependencyResolver;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.config.ParentMuleContextAwareConfigurationBuilder;
import org.mule.runtime.core.internal.config.RuntimeLockFactoryUtil;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.context.NullDomainMuleContextLifecycleStrategy;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.lifecycle.LifecycleStrategy;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.internal.memory.management.ArtifactMemoryManagementService;
import org.mule.runtime.internal.memory.management.DefaultMemoryManagementService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ArtifactAstConfigurationBuilder
extends AbstractConfigurationBuilder
implements ParentMuleContextAwareConfigurationBuilder,
ArtifactContextFactory,
ComponentBuildingDefinitionRegistryFactoryAware {
    private final boolean enableLazyInit;
    private final boolean addToolingObjectsToRegistry;
    private final ArtifactAst artifactAst;
    private final Map<String, String> artifactProperties;
    private ApplicationContext parentContext;
    private MuleArtifactContext muleArtifactContext;
    private final ArtifactType artifactType;
    private final LockFactory runtimeLockFactory;
    private final MemoryManagementService memoryManagementService;
    private Optional<ComponentBuildingDefinitionRegistryFactory> componentBuildingDefinitionRegistryFactory = Optional.empty();

    private ArtifactAstConfigurationBuilder(ArtifactAst artifactAst, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInit, boolean addToolingObjectsToRegistry, LockFactory runtimeLockFactory, MemoryManagementService memoryManagementService) throws ConfigurationException {
        this.artifactAst = artifactAst;
        this.artifactProperties = artifactProperties;
        this.artifactType = artifactType;
        this.enableLazyInit = enableLazyInit;
        this.addToolingObjectsToRegistry = addToolingObjectsToRegistry;
        this.runtimeLockFactory = runtimeLockFactory;
        this.memoryManagementService = memoryManagementService;
    }

    public ArtifactAstConfigurationBuilder(ArtifactAst artifactAst, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInit, boolean addToolingObjectsToRegistry) throws ConfigurationException {
        this(artifactAst, artifactProperties, artifactType, enableLazyInit, addToolingObjectsToRegistry, RuntimeLockFactoryUtil.getRuntimeLockFactory(), (MemoryManagementService)DefaultMemoryManagementService.getInstance());
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        if (MuleAstUtils.emptyArtifact().equals(this.artifactAst) && this.artifactType == ArtifactType.DOMAIN) {
            ((DefaultMuleContext)muleContext).setLifecycleStrategy((LifecycleStrategy)new NullDomainMuleContextLifecycleStrategy());
            return;
        }
        LifecycleUtils.initialiseIfNeeded((Object)this, (MuleContext)muleContext);
        OptionalObjectsController applicationObjectController = this.createApplicationObjectController();
        Optional<ConfigurationProperties> parentConfigurationProperties = this.resolveParentConfigurationProperties();
        BaseMuleArtifactContext baseMuleArtifactContext = this.createBaseContext(muleContext, applicationObjectController, parentConfigurationProperties);
        this.serviceConfigurators.forEach(serviceConfigurator -> serviceConfigurator.configure(muleContext.getCustomizationService()));
        this.createBaseRegistry(muleContext, baseMuleArtifactContext);
        this.muleArtifactContext = this.createApplicationContext(muleContext, applicationObjectController, (BaseConfigurationComponentLocator)baseMuleArtifactContext.getBean(BaseConfigurationComponentLocator.class), (ContributedErrorTypeRepository)baseMuleArtifactContext.getBean(ContributedErrorTypeRepository.class), (ContributedErrorTypeLocator)baseMuleArtifactContext.getBean(ContributedErrorTypeLocator.class), (FeatureFlaggingService)baseMuleArtifactContext.getBean(FeatureFlaggingService.class), (ExpressionLanguageMetadataService)baseMuleArtifactContext.getBean(ExpressionLanguageMetadataService.class));
        this.muleArtifactContext.setParent((ApplicationContext)baseMuleArtifactContext);
        this.createSpringRegistry((DefaultMuleContext)muleContext, (ApplicationContext)baseMuleArtifactContext, this.muleArtifactContext);
    }

    private BaseMuleArtifactContext createBaseContext(MuleContext muleContext, OptionalObjectsController applicationObjectController, Optional<ConfigurationProperties> parentConfigurationProperties) {
        BaseMuleArtifactContext baseMuleArtifactContext = new BaseMuleArtifactContext(muleContext, applicationObjectController, parentConfigurationProperties, this.getArtifactProperties(), this.artifactType, this.enableLazyInit);
        if (baseMuleArtifactContext instanceof ConfigurableApplicationContext) {
            baseMuleArtifactContext.setParent(this.parentContext);
        }
        return baseMuleArtifactContext;
    }

    private BaseSpringRegistry createBaseRegistry(MuleContext muleContext, BaseMuleArtifactContext baseMuleArtifactContext) throws InitialisationException {
        BaseSpringRegistry baseRegistry = new BaseSpringRegistry((ApplicationContext)baseMuleArtifactContext, muleContext, ((DefaultMuleContext)muleContext).getLifecycleInterceptor());
        ((DefaultMuleContext)muleContext).setRegistry((Registry)baseRegistry);
        ((DefaultMuleContext)muleContext).setInjector((Injector)baseRegistry);
        baseRegistry.initialise();
        return baseRegistry;
    }

    private MuleArtifactContext createApplicationContext(MuleContext muleContext, OptionalObjectsController optionalObjectsController, BaseConfigurationComponentLocator baseConfigurationComponentLocator, ContributedErrorTypeRepository errorTypeRepository, ContributedErrorTypeLocator errorTypeLocator, FeatureFlaggingService featureFlaggingService, ExpressionLanguageMetadataService expressionLanguageMetadataService) throws Exception {
        return this.doCreateApplicationContext(muleContext, optionalObjectsController, baseConfigurationComponentLocator, errorTypeRepository, errorTypeLocator, featureFlaggingService, expressionLanguageMetadataService);
    }

    protected OptionalObjectsController createApplicationObjectController() {
        OptionalObjectsController applicationObjectcontroller = new DefaultOptionalObjectsController();
        OptionalObjectsController parentObjectController = null;
        if (this.parentContext instanceof MuleArtifactContext) {
            parentObjectController = ((MuleArtifactContext)this.parentContext).getOptionalObjectsController();
        }
        if (parentObjectController != null) {
            applicationObjectcontroller = new CompositeOptionalObjectsController(applicationObjectcontroller, parentObjectController);
        }
        return applicationObjectcontroller;
    }

    private MuleArtifactContext doCreateApplicationContext(MuleContext muleContext, OptionalObjectsController optionalObjectsController, BaseConfigurationComponentLocator baseConfigurationComponentLocator, ContributedErrorTypeRepository errorTypeRepository, ContributedErrorTypeLocator errorTypeLocator, FeatureFlaggingService featureFlaggingService, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        ComponentBuildingDefinitionRegistryFactory resolvedComponentBuildingDefinitionRegistryFactory = this.componentBuildingDefinitionRegistryFactory.orElse(new DefaultComponentBuildingDefinitionRegistryFactory());
        if (this.enableLazyInit) {
            return new LazyMuleArtifactContext(muleContext, this.artifactAst, optionalObjectsController, this.resolveParentConfigurationProperties(), baseConfigurationComponentLocator, errorTypeRepository, errorTypeLocator, this.getArtifactProperties(), this.addToolingObjectsToRegistry, this.artifactType, this.resolveComponentModelInitializer(), this.runtimeLockFactory, resolvedComponentBuildingDefinitionRegistryFactory, (MemoryManagementService)new ArtifactMemoryManagementService(this.memoryManagementService), featureFlaggingService, expressionLanguageMetadataService);
        }
        MuleArtifactContext context = new MuleArtifactContext(muleContext, this.artifactAst, optionalObjectsController, this.resolveParentConfigurationProperties(), baseConfigurationComponentLocator, errorTypeRepository, errorTypeLocator, this.getArtifactProperties(), this.addToolingObjectsToRegistry, this.artifactType, resolvedComponentBuildingDefinitionRegistryFactory, (MemoryManagementService)new ArtifactMemoryManagementService(this.memoryManagementService), featureFlaggingService, expressionLanguageMetadataService);
        context.initialize();
        return context;
    }

    private Optional<ConfigurationProperties> resolveParentConfigurationProperties() {
        Optional<ConfigurationProperties> parentConfigurationProperties = Optional.empty();
        if (this.parentContext != null) {
            parentConfigurationProperties = Optional.of((ConfigurationProperties)this.parentContext.getBean(ConfigurationProperties.class));
        }
        return parentConfigurationProperties;
    }

    private Optional<ComponentModelInitializer> resolveComponentModelInitializer() {
        Optional<ComponentModelInitializer> parentLazyComponentInitializer = Optional.empty();
        if (this.parentContext instanceof ComponentModelInitializer) {
            parentLazyComponentInitializer = Optional.of((ComponentModelInitializer)this.parentContext);
        }
        return parentLazyComponentInitializer;
    }

    private void createSpringRegistry(DefaultMuleContext muleContext, ApplicationContext baseApplicationContext, MuleArtifactContext applicationContext) throws Exception {
        SpringRegistry registry = this.parentContext != null ? this.createRegistryWithParentContext((MuleContext)muleContext, baseApplicationContext, applicationContext) : new SpringRegistry(baseApplicationContext, (ApplicationContext)applicationContext, (MuleContext)muleContext, new ConfigurationDependencyResolver(applicationContext.getApplicationModel()), muleContext.getLifecycleInterceptor());
        muleContext.setRegistry((Registry)registry);
        muleContext.setInjector((Injector)registry);
    }

    private SpringRegistry createRegistryWithParentContext(MuleContext muleContext, ApplicationContext baseApplicationContext, MuleArtifactContext applicationContext) throws ConfigurationException {
        if (baseApplicationContext instanceof ConfigurableApplicationContext) {
            return new SpringRegistry(baseApplicationContext, (ApplicationContext)applicationContext, muleContext, new ConfigurationDependencyResolver(applicationContext.getApplicationModel()), ((DefaultMuleContext)muleContext).getLifecycleInterceptor());
        }
        throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"Cannot set a parent context if the ApplicationContext does not implement ConfigurableApplicationContext"));
    }

    protected synchronized void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
        if (lifecycleManager.isPhaseComplete("start")) {
            lifecycleManager.fireLifecycle("start");
        }
    }

    @Override
    public ArtifactContext createArtifactContext() {
        return new SpringArtifactContext(this.muleArtifactContext);
    }

    public void setParentContext(MuleContext domainContext, ArtifactAst parentAst) {
        this.parentContext = (ApplicationContext)((MuleContextWithRegistry)domainContext).getRegistry().get("springApplicationContext");
    }

    @Override
    public void setComponentBuildingDefinitionRegistryFactory(ComponentBuildingDefinitionRegistryFactory componentBuildingDefinitionRegistryFactory) {
        this.componentBuildingDefinitionRegistryFactory = Optional.ofNullable(componentBuildingDefinitionRegistryFactory);
    }

    public Map<String, String> getArtifactProperties() {
        return this.artifactProperties;
    }
}

