/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.mule.runtime.dsl.api.component.ObjectTypeProvider;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.SmartFactoryBean;

public class ObjectFactoryClassRepository {
    private static final LoadingCache<ClassLoader, ClassLoader> COMPOSITE_CL_CACHE = Caffeine.newBuilder().weakKeys().weakValues().build(cl -> CompositeClassLoader.from((ClassLoader)ObjectFactoryClassRepository.class.getClassLoader(), (ClassLoader)cl));
    public static final String IS_SINGLETON = "isSingleton";
    public static final String OBJECT_TYPE_CLASS = "objectTypeClass";
    public static final String IS_PROTOTYPE = "isPrototype";
    public static final String IS_EAGER_INIT = "isEagerInit";
    private final ByteBuddy byteBuddy = new ByteBuddy();
    private final IsEagerInitGetterInterceptor interceptor = new IsEagerInitGetterInterceptor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<ObjectFactory> getObjectFactoryClass(Class objectFactoryType) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        synchronized (classLoader) {
            String name = objectFactoryType.getName() + "_ByteBuddy";
            ClassLoader classLoader2 = this.getClass().getClassLoader();
            if (SmartFactoryBean.class.getClassLoader() != objectFactoryType.getClassLoader()) {
                classLoader2 = (ClassLoader)COMPOSITE_CL_CACHE.get((Object)objectFactoryType.getClassLoader());
            }
            try {
                return Class.forName(name, true, classLoader2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.createObjectFactoryDynamicClass(objectFactoryType, name, classLoader2);
            }
        }
    }

    private Class<ObjectFactory> createObjectFactoryDynamicClass(Class objectFactoryType, String name, ClassLoader classLoader) {
        return this.byteBuddy.subclass(objectFactoryType, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS).name(name).defineField(IS_SINGLETON, Boolean.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).defineField(OBJECT_TYPE_CLASS, Class.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).defineField(IS_PROTOTYPE, Boolean.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).defineField(IS_EAGER_INIT, Supplier.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).implement(new Type[]{SmartFactoryBeanInterceptor.class}).intercept((Implementation)FieldAccessor.ofBeanProperty()).method((ElementMatcher)ElementMatchers.named((String)IS_SINGLETON).and((ElementMatcher)ElementMatchers.isDeclaredBy(FactoryBean.class))).intercept((Implementation)MethodDelegation.toField((String)IS_SINGLETON)).method((ElementMatcher)ElementMatchers.named((String)"getObjectType").and((ElementMatcher)ElementMatchers.isDeclaredBy(FactoryBean.class))).intercept((Implementation)(ObjectTypeProvider.class.isAssignableFrom(objectFactoryType) ? MethodCall.invokeSuper() : MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)"getObjectTypeClass")))).method((ElementMatcher)ElementMatchers.named((String)IS_PROTOTYPE).and((ElementMatcher)ElementMatchers.isDeclaredBy(SmartFactoryBean.class))).intercept((Implementation)MethodDelegation.toField((String)IS_PROTOTYPE)).method((ElementMatcher)ElementMatchers.named((String)IS_EAGER_INIT).and((ElementMatcher)ElementMatchers.isDeclaredBy(SmartFactoryBean.class))).intercept((Implementation)MethodDelegation.to((Object)this.interceptor)).method((ElementMatcher)ElementMatchers.named((String)"getObject").and((ElementMatcher)ElementMatchers.isDeclaredBy(FactoryBean.class))).intercept((Implementation)MethodCall.invokeSuper()).make().load(classLoader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
    }

    @Deprecated
    public Class<ObjectFactory> getObjectFactoryDynamicClass(ComponentBuildingDefinition componentBuildingDefinition, Class objectFactoryType, Class createdObjectType, Supplier<Boolean> isLazyInitFunction) {
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(new Class[]{SmartFactoryBean.class});
        enhancer.setSuperclass(objectFactoryType);
        enhancer.setCallbackType(MethodInterceptor.class);
        if (SmartFactoryBean.class.getClassLoader() != objectFactoryType.getClassLoader()) {
            enhancer.setClassLoader((ClassLoader)COMPOSITE_CL_CACHE.get((Object)objectFactoryType.getClassLoader()));
        }
        enhancer.setUseCache(true);
        boolean prototype = componentBuildingDefinition.isPrototype();
        Class factoryBeanClass = enhancer.createClass();
        Enhancer.registerStaticCallbacks((Class)factoryBeanClass, (Callback[])new Callback[]{(obj, method, args, proxy) -> {
            boolean eager;
            boolean bl = eager = (Boolean)isLazyInitFunction.get() == false;
            if (method.getName().equals(IS_SINGLETON)) {
                return !prototype;
            }
            if (method.getName().equals("getObjectType") && !ObjectTypeProvider.class.isAssignableFrom(obj.getClass())) {
                return createdObjectType;
            }
            if (method.getName().equals("getObject")) {
                return proxy.invokeSuper(obj, args);
            }
            if (method.getName().equals(IS_PROTOTYPE)) {
                return prototype;
            }
            if (method.getName().equals(IS_EAGER_INIT)) {
                return eager;
            }
            return proxy.invokeSuper(obj, args);
        }});
        return factoryBeanClass;
    }

    public static interface SmartFactoryBeanInterceptor
    extends SmartFactoryBean {
        public Boolean getIsSingleton();

        public void setIsSingleton(Boolean var1);

        public Class getObjectTypeClass();

        public void setObjectTypeClass(Class var1);

        public boolean getIsPrototype();

        public void setIsPrototype(Boolean var1);

        public Supplier getIsEagerInit();

        public void setIsEagerInit(Supplier var1);
    }

    protected static class IsEagerInitGetterInterceptor
    implements InvocationHandler {
        protected IsEagerInitGetterInterceptor() {
        }

        @Override
        @RuntimeType
        public Object invoke(@This Object object, @Origin Method method, @AllArguments Object[] args) throws Throwable {
            return ((SmartFactoryBeanInterceptor)object).getIsEagerInit().get();
        }
    }
}

