/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.function.Supplier;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.mule.runtime.dsl.api.component.ObjectTypeProvider;
import org.springframework.beans.factory.SmartFactoryBean;

public class ObjectFactoryClassRepository {
    private static final LoadingCache<ClassLoader, ClassLoader> COMPOSITE_CL_CACHE = Caffeine.newBuilder().weakKeys().weakValues().build(cl -> CompositeClassLoader.from((ClassLoader)ObjectFactoryClassRepository.class.getClassLoader(), (ClassLoader)cl));

    public Class<ObjectFactory> getObjectFactoryClass(ComponentBuildingDefinition componentBuildingDefinition, Class objectFactoryType, Class createdObjectType, Supplier<Boolean> isLazyInitFunction) {
        return this.getObjectFactoryDynamicClass(componentBuildingDefinition, objectFactoryType, createdObjectType, isLazyInitFunction);
    }

    private Class<ObjectFactory> getObjectFactoryDynamicClass(ComponentBuildingDefinition componentBuildingDefinition, Class objectFactoryType, Class createdObjectType, Supplier<Boolean> isLazyInitFunction) {
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(new Class[]{SmartFactoryBean.class});
        enhancer.setSuperclass(objectFactoryType);
        enhancer.setCallbackType(MethodInterceptor.class);
        if (SmartFactoryBean.class.getClassLoader() != objectFactoryType.getClassLoader()) {
            enhancer.setClassLoader((ClassLoader)COMPOSITE_CL_CACHE.get((Object)objectFactoryType.getClassLoader()));
        }
        enhancer.setUseCache(true);
        boolean prototype = componentBuildingDefinition.isPrototype();
        Class factoryBeanClass = enhancer.createClass();
        Enhancer.registerStaticCallbacks((Class)factoryBeanClass, (Callback[])new Callback[]{(obj, method, args, proxy) -> {
            boolean eager;
            boolean bl = eager = (Boolean)isLazyInitFunction.get() == false;
            if (method.getName().equals("isSingleton")) {
                return !prototype;
            }
            if (method.getName().equals("getObjectType") && !ObjectTypeProvider.class.isAssignableFrom(obj.getClass())) {
                return createdObjectType;
            }
            if (method.getName().equals("getObject")) {
                return proxy.invokeSuper(obj, args);
            }
            if (method.getName().equals("isPrototype")) {
                return prototype;
            }
            if (method.getName().equals("isEagerInit")) {
                return eager;
            }
            return proxy.invokeSuper(obj, args);
        }});
        return factoryBeanClass;
    }
}

