/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CreateParamBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.MapFactoryBean;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;

class MapBeanDefinitionCreator
extends BeanDefinitionCreator<CreateParamBeanDefinitionRequest> {
    MapBeanDefinitionCreator() {
    }

    @Override
    boolean handleRequest(Map<ComponentAst, SpringComponentModel> springComponentModels, CreateParamBeanDefinitionRequest request) {
        if (request.getComponentHierarchy().isEmpty()) {
            return false;
        }
        ComponentBuildingDefinition componentBuildingDefinition = request.getComponentBuildingDefinition();
        Class type = request.getSpringComponentModel().getType();
        if (Map.class.isAssignableFrom(type) && componentBuildingDefinition.getObjectFactoryType() == null) {
            Collection items = (Collection)request.getParam().getValue().getRight();
            items.forEach(request.getNestedComponentParamProcessor());
            ManagedList managedList = items.stream().map(springComponentModels::get).map(SpringComponentModel::getBeanDefinition).collect(Collectors.toCollection(ManagedList::new));
            request.getSpringComponentModel().setBeanDefinition((BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(MapFactoryBean.class).addConstructorArgValue((Object)managedList).addConstructorArgValue(type).getBeanDefinition());
            return true;
        }
        return false;
    }
}

