/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionBuilderHelper;
import org.mule.runtime.config.internal.dsl.spring.CommonComponentBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ComponentValue;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.CreateParamBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.DefaultValueVisitor;
import org.mule.runtime.config.internal.dsl.spring.MapFactoryBean;
import org.mule.runtime.config.internal.dsl.spring.ObjectReferencePopulator;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.AttributeDefinitionVisitor;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.mule.runtime.dsl.api.component.SetterAttributeDefinition;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;

class ComponentConfigurationBuilder<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentConfigurationBuilder.class);
    private static final String GLOBAL_FUNCTIONS_START_TAG = "<global-functions><![CDATA[";
    private static final String GLOBAL_FUNCTIONS_END_TAG = "]]></global-functions>";
    private final BeanDefinitionBuilderHelper beanDefinitionBuilderHelper;
    private final ObjectReferencePopulator objectReferencePopulator = new ObjectReferencePopulator();
    private final List<ComponentValue> complexParameters;
    private final ComponentAst ownerComponent;
    private final ComponentAst component;
    private final CreateBeanDefinitionRequest<T> createBeanDefinitionRequest;

    public ComponentConfigurationBuilder(Map<ComponentAst, SpringComponentModel> springComponentModels, ComponentAst ownerComponent, ComponentAst component, CreateBeanDefinitionRequest<T> request, BeanDefinitionBuilderHelper beanDefinitionBuilderHelper) {
        this.ownerComponent = ownerComponent;
        this.component = request.resolveConfigurationComponent();
        this.createBeanDefinitionRequest = request;
        this.beanDefinitionBuilderHelper = beanDefinitionBuilderHelper;
        this.complexParameters = this.collectComplexParametersWithTypes(springComponentModels, ownerComponent, component);
    }

    public void processConfiguration() {
        for (SetterAttributeDefinition setterAttributeDefinition : this.createBeanDefinitionRequest.getComponentBuildingDefinition().getSetterParameterDefinitions()) {
            AttributeDefinition attributeDefinition = setterAttributeDefinition.getAttributeDefinition();
            attributeDefinition.accept((AttributeDefinitionVisitor)this.setterVisitor(setterAttributeDefinition.getAttributeName(), attributeDefinition));
        }
        for (AttributeDefinition attributeDefinition : this.createBeanDefinitionRequest.getComponentBuildingDefinition().getConstructorAttributeDefinition()) {
            attributeDefinition.accept((AttributeDefinitionVisitor)this.constructorVisitor());
        }
    }

    private List<ComponentValue> collectComplexParametersWithTypes(Map<ComponentAst, SpringComponentModel> springComponentModels, ComponentAst ownerComponent, ComponentAst component) {
        Stream<SpringComponentModel> baseStream = component != null ? Stream.concat(this.createBeanDefinitionRequest.getParamsModels().stream(), component.directChildrenStream().map(springComponentModels::get).filter(Objects::nonNull)) : this.createBeanDefinitionRequest.getParamsModels().stream();
        return baseStream.map(springModel -> new ComponentValue(springModel.getComponentIdentifier(), this.resolveBeanDefinitionType((SpringComponentModel)springModel), springModel.getBeanDefinition() != null ? springModel.getBeanDefinition() : springModel.getBeanReference())).collect(Collectors.toList());
    }

    private Class<?> resolveBeanDefinitionType(SpringComponentModel springModel) {
        if (springModel.getType() != null) {
            return springModel.getType();
        }
        if (springModel.getBeanDefinition() == null) {
            return null;
        }
        try {
            String beanClassName = springModel.getBeanDefinition().getBeanClassName();
            if (beanClassName != null) {
                return ClassUtils.getClass((String)beanClassName);
            }
            return Object.class;
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("Exception trying to determine ComponentModel type: ", (Throwable)e);
            return Object.class;
        }
    }

    private ConfigurableAttributeDefinitionVisitor constructorVisitor() {
        return new ConfigurableAttributeDefinitionVisitor(this.beanDefinitionBuilderHelper::addConstructorValue);
    }

    private ConfigurableAttributeDefinitionVisitor setterVisitor(String propertyName, AttributeDefinition attributeDefinition) {
        DefaultValueVisitor defaultValueVisitor = new DefaultValueVisitor();
        attributeDefinition.accept((AttributeDefinitionVisitor)defaultValueVisitor);
        Optional<Object> defaultValue = defaultValueVisitor.getDefaultValue();
        return new ConfigurableAttributeDefinitionVisitor(value -> {
            if (this.isPropertySetWithUserConfigValue(propertyName, defaultValue, value)) {
                return;
            }
            this.beanDefinitionBuilderHelper.forProperty(propertyName).addValue(value);
        });
    }

    private boolean isPropertySetWithUserConfigValue(String propertyName, Optional<Object> defaultValue, Object value) {
        return defaultValue.isPresent() && defaultValue.get().equals(value) && this.beanDefinitionBuilderHelper.hasValueForProperty(propertyName);
    }

    private boolean shouldSetDefaultFrequencyForFixedFrequencyStrategy(String parameterName, ComponentParameterAst parameter) {
        return "frequency".equals(parameterName) && this.ownerComponent.getIdentifier().equals(ApplicationModel.FIXED_FREQUENCY_STRATEGY_IDENTIFIER) && parameter.isDefaultValue() && parameter.getResolvedRawValue() == null;
    }

    private ManagedList constructManagedList(List<Object> beans) {
        ManagedList managedList = new ManagedList();
        managedList.addAll(beans);
        return managedList;
    }

    private List<Object> fromBeanDefinitionTypePairToBeanDefinition(List<ComponentValue> undefinedComplexParameters) {
        return undefinedComplexParameters.stream().map(ComponentValue::getBean).collect(Collectors.toList());
    }

    private class ValueExtractorAttributeDefinitionVisitor
    implements AttributeDefinitionVisitor {
        private Object value;

        private ValueExtractorAttributeDefinitionVisitor() {
        }

        public Object getValue() {
            return this.value;
        }

        public void onReferenceObject(Class<?> objectType) {
            ComponentConfigurationBuilder.this.objectReferencePopulator.populate(objectType, referenceId -> {
                this.value = new RuntimeBeanReference(referenceId);
            });
        }

        public void onReferenceSimpleParameter(String configAttributeName) {
            if (!ComponentConfigurationBuilder.this.createBeanDefinitionRequest.getComponentBuildingDefinition().getIgnoredConfigurationParameters().contains(configAttributeName)) {
                this.getParameterValue(configAttributeName, null).ifPresent(reference -> {
                    this.value = new RuntimeBeanReference((String)reference);
                });
            }
        }

        public void onSoftReferenceSimpleParameter(String softReference) {
            if (!ComponentConfigurationBuilder.this.createBeanDefinitionRequest.getComponentBuildingDefinition().getIgnoredConfigurationParameters().contains(softReference)) {
                this.getParameterValue(softReference, null).ifPresent(reference -> {
                    this.value = reference;
                });
            }
        }

        public void onReferenceFixedParameter(String reference) {
            this.value = new RuntimeBeanReference(reference);
        }

        public void onFixedValue(Object value) {
            this.value = value;
        }

        public void onConfigurationParameter(String parameterName, Object defaultValue, Optional<TypeConverter> typeConverter) {
            if (!ComponentConfigurationBuilder.this.createBeanDefinitionRequest.getComponentBuildingDefinition().getIgnoredConfigurationParameters().contains(parameterName)) {
                this.value = this.getParameterValue(parameterName, defaultValue).map(parameterValue -> typeConverter.map(tc -> tc.convert(parameterValue)).orElse(parameterValue)).orElse(null);
            }
        }

        private Optional<Object> getParameterValue(String parameterName, Object defaultValue) {
            Object parameterValue;
            ComponentParameterAst parameter = ComponentConfigurationBuilder.this.ownerComponent.getModel(ParameterizedModel.class).map(ownerComponentModel -> this.doResolveParameter(ComponentConfigurationBuilder.this.createBeanDefinitionRequest.getParameter(parameterName))).orElse(null);
            if (parameter == null) {
                parameterValue = defaultValue;
            } else if (ComponentConfigurationBuilder.this.shouldSetDefaultFrequencyForFixedFrequencyStrategy(parameterName, parameter)) {
                parameterValue = this.getDefaultSchedulerFixedFrequency();
            } else {
                parameterValue = parameter.getValue().mapLeft(expr -> "#[" + expr + "]").getValue().orElse(null);
                if (defaultValue != null && parameterValue == null) {
                    LOGGER.warn("Parameter {} from extension {} has a defaultValue configured in the componentBuildingDefinition but not in the extensionModel.", (Object)parameterName, (Object)ComponentConfigurationBuilder.this.ownerComponent.getIdentifier().getNamespace());
                    parameterValue = defaultValue;
                }
            }
            if (parameterValue instanceof ComponentAst || parameterValue instanceof Collection) {
                return Optional.empty();
            }
            return Optional.ofNullable(parameterValue);
        }

        private ComponentParameterAst doResolveParameter(ComponentParameterAst param) {
            if (param == null && ComponentConfigurationBuilder.this.component != null) {
                return ComponentConfigurationBuilder.this.ownerComponent.getParameter("General", ComponentConfigurationBuilder.this.component.getIdentifier().getName());
            }
            return param;
        }

        private long getDefaultSchedulerFixedFrequency() {
            String freq = System.getProperty("mule.config.scheduler.defaultFixedFrequency", "1000");
            try {
                return Long.valueOf(freq);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Invalid value for System Property %s. A long number was expected but '%s' found instead", "mule.config.scheduler.defaultFixedFrequency", freq));
            }
        }

        public void onReferenceConfigurationParameter(String parameterName, Object defaultValue, Optional<TypeConverter> typeConverter) {
            this.onConfigurationParameter(parameterName, defaultValue, typeConverter);
        }

        public void onUndefinedSimpleParameters() {
            this.value = ComponentConfigurationBuilder.this.component.getModel(ParameterizedModel.class).map(pm -> ComponentConfigurationBuilder.this.component.getParameters().stream().filter(param -> !ComponentConfigurationBuilder.this.createBeanDefinitionRequest.getComponentBuildingDefinition().getIgnoredConfigurationParameters().contains(param.getModel().getName())).filter(param -> param.getResolvedRawValue() != null).collect(Collectors.toMap(param -> param.getModel().getName(), ComponentParameterAst::getResolvedRawValue))).orElse(null);
        }

        public void onUndefinedComplexParameters() {
            this.value = ComponentConfigurationBuilder.this.constructManagedList(ComponentConfigurationBuilder.this.fromBeanDefinitionTypePairToBeanDefinition(ComponentConfigurationBuilder.this.complexParameters));
        }

        public void onComplexChildCollection(Class<?> type, Optional<String> wrapperIdentifier) {
            Predicate<ComponentValue> matchesTypeAndIdentifierPredicate = this.getTypeAndIdentifierPredicate(type, wrapperIdentifier);
            List matchingComponentValues = ComponentConfigurationBuilder.this.complexParameters.stream().filter(matchesTypeAndIdentifierPredicate).collect(Collectors.toList());
            matchingComponentValues.stream().forEach(ComponentConfigurationBuilder.this.complexParameters::remove);
            if (wrapperIdentifier.isPresent() && !matchingComponentValues.isEmpty()) {
                this.value = ((ComponentValue)matchingComponentValues.get(0)).getBean();
            } else if (!matchingComponentValues.isEmpty()) {
                this.value = ComponentConfigurationBuilder.this.constructManagedList(ComponentConfigurationBuilder.this.fromBeanDefinitionTypePairToBeanDefinition(matchingComponentValues));
            }
        }

        public void onComplexChildMap(Class<?> keyType, Class<?> valueType, String wrapperIdentifier) {
            ComponentConfigurationBuilder.this.complexParameters.stream().filter(this.getTypeAndIdentifierPredicate(MapFactoryBean.class, Optional.ofNullable(wrapperIdentifier))).findFirst().ifPresent(componentValue -> {
                ComponentConfigurationBuilder.this.complexParameters.remove(componentValue);
                this.value = componentValue.getBean();
            });
        }

        public void onComplexChild(Class<?> type, Optional<String> wrapperIdentifier, Optional<String> childIdentifier) {
            Optional<String> identifier = wrapperIdentifier.isPresent() ? wrapperIdentifier : childIdentifier;
            Predicate<ComponentValue> matchesTypeAndIdentifierPredicate = this.getTypeAndIdentifierPredicate(type, identifier);
            Optional<ComponentValue> value = ComponentConfigurationBuilder.this.complexParameters.stream().filter(matchesTypeAndIdentifierPredicate).findFirst();
            value.ifPresent(beanDefinitionTypePair -> {
                Object bean;
                ComponentConfigurationBuilder.this.complexParameters.remove(beanDefinitionTypePair);
                this.value = bean = beanDefinitionTypePair.getBean();
            });
        }

        private Predicate<ComponentValue> getTypeAndIdentifierPredicate(Class<?> type, Optional<String> identifierOptional) {
            return componentValue -> {
                AtomicReference<Boolean> matchesIdentifier = new AtomicReference<Boolean>(true);
                identifierOptional.ifPresent(wrapperIdentifier -> matchesIdentifier.set(wrapperIdentifier.equals(componentValue.getComponentIdentifier().getName())));
                return matchesIdentifier.get() != false && (CommonComponentBeanDefinitionCreator.areMatchingTypes(type, componentValue.getType()) || CommonComponentBeanDefinitionCreator.areMatchingTypes(Map.class, componentValue.getType()) && CommonComponentBeanDefinitionCreator.areMatchingTypes(MapFactoryBean.class, type));
            };
        }

        public void onValueFromTextContent() {
            ComponentAst componentAst = ComponentConfigurationBuilder.this.createBeanDefinitionRequest.getComponent();
            Optional value = Optional.empty();
            if (componentAst != null && componentAst.getMetadata() != null) {
                value = componentAst.getMetadata().getSourceCode();
            }
            if (value != null && value.isPresent() && ((String)value.get()).startsWith(ComponentConfigurationBuilder.GLOBAL_FUNCTIONS_START_TAG)) {
                Optional<String> data = value.map(val -> val.substring(ComponentConfigurationBuilder.GLOBAL_FUNCTIONS_START_TAG.length(), val.indexOf(ComponentConfigurationBuilder.GLOBAL_FUNCTIONS_END_TAG)));
                this.value = data.orElse("");
            } else {
                this.getParameterValue(((CreateParamBeanDefinitionRequest)ComponentConfigurationBuilder.this.createBeanDefinitionRequest).getParam().getModel().getName(), null).ifPresent(v -> {
                    this.value = v;
                });
            }
        }

        public void onMultipleValues(KeyAttributeDefinitionPair[] definitions) {
            for (KeyAttributeDefinitionPair definition : definitions) {
                definition.getAttributeDefinition().accept((AttributeDefinitionVisitor)this);
            }
        }
    }

    private class ConfigurableAttributeDefinitionVisitor
    implements AttributeDefinitionVisitor {
        private final Consumer<Object> valueConsumer;

        ConfigurableAttributeDefinitionVisitor(Consumer<Object> valueConsumer) {
            this.valueConsumer = valueConsumer;
        }

        public void onReferenceObject(Class<?> objectType) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onReferenceObject(objectType);
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onReferenceSimpleParameter(String configAttributeName) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onReferenceSimpleParameter(configAttributeName);
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onSoftReferenceSimpleParameter(String softReference) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onSoftReferenceSimpleParameter(softReference);
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onReferenceFixedParameter(String reference) {
            this.valueConsumer.accept(new RuntimeBeanReference(reference));
        }

        public void onFixedValue(Object value) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onFixedValue(value);
            this.valueConsumer.accept(value);
        }

        public void onConfigurationParameter(String parameterName, Object defaultValue, Optional<TypeConverter> typeConverter) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onConfigurationParameter(parameterName, defaultValue, typeConverter);
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onReferenceConfigurationParameter(String parameterName, Object defaultValue, Optional<TypeConverter> typeConverter) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onConfigurationParameter(parameterName, defaultValue, typeConverter);
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onUndefinedSimpleParameters() {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onUndefinedSimpleParameters();
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onUndefinedComplexParameters() {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onUndefinedComplexParameters();
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onComplexChildCollection(Class<?> type, Optional<String> wrapperIdentifier) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onComplexChildCollection(type, wrapperIdentifier);
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onComplexChildMap(Class<?> keyType, Class<?> valueType, String wrapperIdentifier) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onComplexChildMap(keyType, valueType, wrapperIdentifier);
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onComplexChild(Class<?> type, Optional<String> wrapperIdentifier, Optional<String> childIdentifier) {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onComplexChild(type, wrapperIdentifier, childIdentifier);
            Object value = valueExtractor.getValue();
            if (value != null) {
                this.valueConsumer.accept(value);
            }
        }

        public void onValueFromTextContent() {
            ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
            valueExtractor.onValueFromTextContent();
            this.valueConsumer.accept(valueExtractor.getValue());
        }

        public void onMultipleValues(KeyAttributeDefinitionPair[] definitions) {
            ManagedMap managedMap = new ManagedMap();
            for (KeyAttributeDefinitionPair definition : definitions) {
                ValueExtractorAttributeDefinitionVisitor valueExtractor = new ValueExtractorAttributeDefinitionVisitor();
                definition.getAttributeDefinition().accept((AttributeDefinitionVisitor)valueExtractor);
                Object value = valueExtractor.getValue();
                if (value == null) continue;
                managedMap.put((Object)definition.getKey(), value);
            }
            this.valueConsumer.accept(managedMap);
        }
    }
}

