/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.config.api.ArtifactContextFactory;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationUtils;
import org.mule.runtime.config.internal.ComponentModelInitializer;
import org.mule.runtime.config.internal.CompositeOptionalObjectsController;
import org.mule.runtime.config.internal.ConfigurationDependencyResolver;
import org.mule.runtime.config.internal.DefaultComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.DefaultOptionalObjectsController;
import org.mule.runtime.config.internal.LazyMuleArtifactContext;
import org.mule.runtime.config.internal.MuleArtifactContext;
import org.mule.runtime.config.internal.OptionalObjectsController;
import org.mule.runtime.config.internal.SpringRegistry;
import org.mule.runtime.config.internal.artifact.SpringArtifactContext;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.StaticConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.model.ComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.config.ParentMuleContextAwareConfigurationBuilder;
import org.mule.runtime.core.internal.config.RuntimeLockFactoryUtil;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.context.NullDomainMuleContextLifecycleStrategy;
import org.mule.runtime.core.internal.exception.FilteredErrorTypeRepository;
import org.mule.runtime.core.internal.lifecycle.LifecycleStrategy;
import org.mule.runtime.core.internal.registry.CompositeMuleRegistryHelper;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.dsl.api.ConfigResource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringXmlConfigurationBuilder
extends AbstractResourceConfigurationBuilder
implements ParentMuleContextAwareConfigurationBuilder,
ArtifactContextFactory {
    private ArtifactDeclaration artifactDeclaration;
    private boolean enableLazyInit = false;
    private boolean disableXmlValidations = false;
    private SpringRegistry registry;
    private ArtifactAst parentArtifactAst;
    private ApplicationContext parentContext;
    private MuleArtifactContext muleArtifactContext;
    private final ArtifactType artifactType;
    private final LockFactory runtimeLockFactory;
    private Optional<ComponentBuildingDefinitionRegistryFactory> componentBuildingDefinitionRegistryFactory = Optional.empty();
    @Inject
    private FeatureFlaggingService featureFlaggingService;

    private SpringXmlConfigurationBuilder(String[] configResources, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInit, boolean disableXmlValidations, LockFactory runtimeLockFactory) throws ConfigurationException {
        super(configResources, artifactProperties);
        this.artifactType = artifactType;
        this.enableLazyInit = enableLazyInit;
        this.disableXmlValidations = disableXmlValidations;
        this.runtimeLockFactory = runtimeLockFactory;
    }

    public SpringXmlConfigurationBuilder(String[] configResources, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInit, boolean disableXmlValidations) throws ConfigurationException {
        this(configResources, artifactProperties, artifactType, enableLazyInit, disableXmlValidations, RuntimeLockFactoryUtil.getRuntimeLockFactory());
    }

    @Deprecated
    public SpringXmlConfigurationBuilder(String configResources, Map<String, String> artifactProperties, ArtifactType artifactType) throws ConfigurationException {
        this(new String[]{configResources}, artifactProperties, artifactType, false, false);
    }

    @Deprecated
    public SpringXmlConfigurationBuilder(String configResource) throws ConfigurationException {
        this(configResource, Collections.emptyMap(), ArtifactType.APP);
    }

    @Deprecated
    public SpringXmlConfigurationBuilder(String[] configFiles, Map<String, String> artifactProperties) throws ConfigurationException {
        this(configFiles, artifactProperties, ArtifactType.APP, false, false);
    }

    @Deprecated
    public SpringXmlConfigurationBuilder(String[] configFiles, boolean enableLazyInit, boolean disableXmlValidations) throws ConfigurationException {
        this(configFiles, Collections.emptyMap(), ArtifactType.APP, enableLazyInit, disableXmlValidations, RuntimeLockFactoryUtil.getRuntimeLockFactory());
    }

    public SpringXmlConfigurationBuilder(String[] configurationFiles, ArtifactDeclaration artifactDeclaration, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInitialisation, boolean disableXmlValidations, LockFactory runtimeLockFactory) throws ConfigurationException {
        this(configurationFiles, artifactProperties, artifactType, enableLazyInitialisation, disableXmlValidations, runtimeLockFactory);
        this.artifactDeclaration = artifactDeclaration;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        if (ArrayUtils.isEmpty((Object[])this.artifactConfigResources) && this.artifactType == ArtifactType.DOMAIN) {
            ((DefaultMuleContext)muleContext).setLifecycleStrategy((LifecycleStrategy)new NullDomainMuleContextLifecycleStrategy());
            return;
        }
        LifecycleUtils.initialiseIfNeeded((Object)this, (MuleContext)muleContext);
        this.muleArtifactContext = this.createApplicationContext(muleContext);
        this.createSpringRegistry(muleContext, (ApplicationContext)this.muleArtifactContext);
    }

    protected void addResources(List<ConfigResource> allResources) {
    }

    private MuleArtifactContext createApplicationContext(MuleContext muleContext) throws Exception {
        OptionalObjectsController applicationObjectcontroller = new DefaultOptionalObjectsController();
        OptionalObjectsController parentObjectController = null;
        if (this.parentContext instanceof MuleArtifactContext) {
            parentObjectController = ((MuleArtifactContext)this.parentContext).getOptionalObjectsController();
        }
        if (parentObjectController != null) {
            applicationObjectcontroller = new CompositeOptionalObjectsController(applicationObjectcontroller, parentObjectController);
        }
        MuleArtifactContext muleArtifactContext = this.doCreateApplicationContext(muleContext, this.artifactDeclaration, applicationObjectcontroller);
        this.serviceConfigurators.forEach(serviceConfigurator -> serviceConfigurator.configure(muleContext.getCustomizationService()));
        return muleArtifactContext;
    }

    private MuleArtifactContext doCreateApplicationContext(MuleContext muleContext, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController) {
        MuleArtifactContext muleArtifactContext;
        ComponentBuildingDefinitionRegistryFactory componentBuildingDefinitionRegistryFactory = this.componentBuildingDefinitionRegistryFactory.orElse(new DefaultComponentBuildingDefinitionRegistryFactory());
        ArtifactAst artifactAst = this.createApplicationModel(this.getExtensions(muleContext.getExtensionManager()), artifactDeclaration, this.resolveArtifactConfigResources(), this.getArtifactProperties(), this.disableXmlValidations);
        if (this.enableLazyInit) {
            muleArtifactContext = new LazyMuleArtifactContext(muleContext, artifactAst, optionalObjectsController, this.resolveParentConfigurationProperties(), this.getArtifactProperties(), this.artifactType, this.resolveComponentModelInitializer(), this.runtimeLockFactory, componentBuildingDefinitionRegistryFactory, this.featureFlaggingService);
        } else {
            muleArtifactContext = new MuleArtifactContext(muleContext, artifactAst, optionalObjectsController, this.resolveParentConfigurationProperties(), this.getArtifactProperties(), this.artifactType, componentBuildingDefinitionRegistryFactory, this.featureFlaggingService);
            muleArtifactContext.initialize();
        }
        return muleArtifactContext;
    }

    private Set<ExtensionModel> getExtensions(ExtensionManager extensionManager) {
        return extensionManager == null ? Collections.emptySet() : extensionManager.getExtensions();
    }

    private ArtifactAst createApplicationModel(Set<ExtensionModel> extensions, ArtifactDeclaration artifactDeclaration, ConfigResource[] artifactConfigResources, Map<String, String> artifactProperties, boolean disableXmlValidations) {
        try {
            ArtifactAst artifactAst;
            if (artifactDeclaration == null) {
                if (artifactConfigResources.length == 0) {
                    artifactAst = MuleAstUtils.emptyArtifact();
                } else {
                    AstXmlParser parser = this.createMuleXmlParser(extensions, artifactProperties, disableXmlValidations);
                    artifactAst = parser.parse(Arrays.stream(artifactConfigResources).map(configFile -> new Pair((Object)configFile.getResourceName(), (Object)configFile.getInputStream())).collect(Collectors.toList()));
                }
            } else {
                artifactAst = ArtifactDeclarationUtils.toArtifactast(artifactDeclaration, extensions);
            }
            return artifactAst;
        }
        catch (MuleRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private AstXmlParser createMuleXmlParser(Set<ExtensionModel> extensions, Map<String, String> artifactProperties, boolean disableXmlValidations) {
        DefaultConfigurationPropertiesResolver propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), new StaticConfigurationPropertiesProvider(artifactProperties));
        AstXmlParser.Builder builder = AstXmlParser.builder().withPropertyResolver(propertyKey -> (String)propertyResolver.resolveValue(propertyKey)).withExtensionModels(extensions).withParentArtifact(this.resolveParentArtifact());
        if (!this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ENTITY_RESOLVER_FAIL_ON_FIRST_ERROR)) {
            builder.withLegacyFailStrategy();
        }
        if (disableXmlValidations) {
            builder.withSchemaValidationsDisabled();
        }
        return builder.build();
    }

    protected ArtifactAst resolveParentArtifact() {
        if (ArtifactType.POLICY.equals((Object)this.artifactType)) {
            if (this.shareErrorTypeRepository()) {
                return this.parentArtifactAst;
            }
            return new BaseArtifactAst(){

                public Set<ExtensionModel> dependencies() {
                    return SpringXmlConfigurationBuilder.this.parentArtifactAst.dependencies();
                }

                public Optional<ArtifactAst> getParent() {
                    return SpringXmlConfigurationBuilder.this.parentArtifactAst.getParent();
                }

                public Stream<ComponentAst> recursiveStream(AstTraversalDirection direction) {
                    return SpringXmlConfigurationBuilder.this.parentArtifactAst.recursiveStream(direction);
                }

                public List<ComponentAst> topLevelComponents() {
                    return SpringXmlConfigurationBuilder.this.parentArtifactAst.topLevelComponents();
                }

                public void updatePropertiesResolver(UnaryOperator<String> newPropertiesResolver) {
                    SpringXmlConfigurationBuilder.this.parentArtifactAst.updatePropertiesResolver(newPropertiesResolver);
                }

                public ErrorTypeRepository getErrorTypeRepository() {
                    return new FilteredErrorTypeRepository(SpringXmlConfigurationBuilder.this.parentArtifactAst.getErrorTypeRepository(), Collections.singleton("HTTP"));
                }

                public Collection<ImportedResource> getImportedResources() {
                    return SpringXmlConfigurationBuilder.this.parentArtifactAst.getImportedResources();
                }
            };
        }
        return this.parentArtifactAst;
    }

    private boolean shareErrorTypeRepository() {
        return Boolean.getBoolean("mule.share.errorTypeRepository");
    }

    private ConfigResource[] resolveArtifactConfigResources() {
        return this.artifactConfigResources;
    }

    private Optional<ConfigurationProperties> resolveParentConfigurationProperties() {
        Optional<Object> parentConfigurationProperties = Optional.empty();
        if (this.parentContext != null) {
            parentConfigurationProperties = Optional.of(this.parentContext.getBean(ConfigurationProperties.class));
        }
        return parentConfigurationProperties;
    }

    private Optional<ComponentModelInitializer> resolveComponentModelInitializer() {
        Optional<ComponentModelInitializer> parentLazyComponentInitializer = Optional.empty();
        if (this.parentContext != null && this.parentContext instanceof ComponentModelInitializer) {
            parentLazyComponentInitializer = Optional.of((ComponentModelInitializer)this.parentContext);
        }
        return parentLazyComponentInitializer;
    }

    private void createSpringRegistry(MuleContext muleContext, ApplicationContext applicationContext) throws Exception {
        if (this.parentContext != null) {
            this.createRegistryWithParentContext(muleContext, applicationContext, this.parentContext);
            if (this.parentContext instanceof MuleArtifactContext && ((MuleArtifactContext)this.parentContext).getMuleContext().getRegistry() instanceof MuleRegistryHelper) {
                MuleRegistryHelper parentMuleRegistryHelper = (MuleRegistryHelper)((MuleArtifactContext)this.parentContext).getMuleContext().getRegistry();
                CompositeMuleRegistryHelper compositeMuleRegistryHelper = new CompositeMuleRegistryHelper((Registry)this.registry, muleContext, parentMuleRegistryHelper);
                ((MuleContextWithRegistry)muleContext).setRegistry((Registry)compositeMuleRegistryHelper);
            } else {
                ((MuleContextWithRegistry)muleContext).setRegistry((Registry)this.registry);
            }
        } else {
            this.registry = new SpringRegistry(applicationContext, muleContext, new ConfigurationDependencyResolver(this.muleArtifactContext.getApplicationModel()), ((DefaultMuleContext)muleContext).getLifecycleInterceptor());
            ((MuleContextWithRegistry)muleContext).setRegistry((Registry)this.registry);
        }
        ((DefaultMuleContext)muleContext).setInjector((Injector)this.registry);
    }

    private void createRegistryWithParentContext(MuleContext muleContext, ApplicationContext applicationContext, ApplicationContext parentContext) throws ConfigurationException {
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"Cannot set a parent context if the ApplicationContext does not implement ConfigurableApplicationContext"));
        }
        ((ConfigurableApplicationContext)applicationContext).setParent(parentContext);
        this.registry = new SpringRegistry(applicationContext, muleContext, new ConfigurationDependencyResolver(this.muleArtifactContext.getApplicationModel()), ((DefaultMuleContext)muleContext).getLifecycleInterceptor());
    }

    protected synchronized void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
        if (lifecycleManager.isPhaseComplete("start")) {
            lifecycleManager.fireLifecycle("start");
        }
    }

    @Override
    public ArtifactContext createArtifactContext() {
        return new SpringArtifactContext(this.muleArtifactContext);
    }

    public void setParentContext(MuleContext domainContext, ArtifactAst parentAst) {
        this.parentContext = (ApplicationContext)((MuleContextWithRegistry)domainContext).getRegistry().get("springApplicationContext");
        this.parentArtifactAst = parentAst;
    }

    public void setComponentBuildingDefinitionRegistryFactory(ComponentBuildingDefinitionRegistryFactory componentBuildingDefinitionRegistryFactory) {
        this.componentBuildingDefinitionRegistryFactory = Optional.ofNullable(componentBuildingDefinitionRegistryFactory);
    }
}

