/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CreateParamBeanDefinitionRequest;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;

class CollectionBeanDefinitionCreator
extends BeanDefinitionCreator<CreateParamBeanDefinitionRequest> {
    CollectionBeanDefinitionCreator() {
    }

    @Override
    boolean handleRequest(Map<ComponentAst, SpringComponentModel> springComponentModels, CreateParamBeanDefinitionRequest request) {
        if (request.getComponentHierarchy().isEmpty()) {
            return false;
        }
        Class<Object> type = request.getSpringComponentModel().getType();
        if (Collection.class.isAssignableFrom(type)) {
            this.doHandleRequest(springComponentModels, request, type);
            return true;
        }
        return false;
    }

    private void doHandleRequest(Map<ComponentAst, SpringComponentModel> springComponentModels, CreateParamBeanDefinitionRequest request, Class<Object> type) {
        request.getSpringComponentModel().setType(type);
        Collection items = (Collection)request.getParam().getValue().getRight();
        items.forEach(request.getNestedComponentParamProcessor());
        ManagedList managedList = items.stream().map(springComponentModels::get).map(innerSpringComp -> innerSpringComp.getBeanDefinition() == null ? innerSpringComp.getBeanReference() : innerSpringComp.getBeanDefinition()).collect(Collectors.toCollection(ManagedList::new));
        request.getSpringComponentModel().setBeanDefinition((BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(type).addConstructorArgValue((Object)managedList).getBeanDefinition());
    }
}

