/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.dsl.model.metadata;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.app.declaration.internal.utils.Preconditions;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.metadata.DslElementIdHelper;
import org.mule.runtime.core.internal.locator.ComponentLocator;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheId;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheIdGenerator;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;

public class DslElementBasedValueProviderCacheIdGenerator
implements ValueProviderCacheIdGenerator<DslElementModel<?>> {
    private ComponentLocator<DslElementModel<?>> locator;

    public DslElementBasedValueProviderCacheIdGenerator(ComponentLocator<DslElementModel<?>> locator) {
        this.locator = locator;
    }

    public Optional<ValueProviderCacheId> getIdForResolvedValues(DslElementModel<?> containerComponent, String parameterName) {
        return this.ifContainsParameter(containerComponent, parameterName).flatMap(ParameterModel::getValueProviderModel).flatMap(valueProviderModel -> this.resolveParametersInformation(containerComponent).flatMap(infoMap -> this.resolveId(containerComponent, (ValueProviderModel)valueProviderModel, (Map<String, ParameterModelInformation>)infoMap)));
    }

    private Optional<ParameterModel> ifContainsParameter(DslElementModel<?> containerComponent, String parameterName) {
        if (containerComponent.getModel() instanceof ParameterizedModel) {
            return ((ParameterizedModel)containerComponent.getModel()).getAllParameterModels().stream().filter(p -> Objects.equal((Object)parameterName, (Object)p.getName())).findAny();
        }
        return Optional.empty();
    }

    private Optional<Map<String, ParameterModelInformation>> resolveParametersInformation(DslElementModel<?> containerComponent) {
        if (containerComponent.getModel() instanceof ParameterizedModel) {
            HashMap parametersDslMap = new HashMap();
            containerComponent.getContainedElements().stream().filter(containedElement -> containedElement.getModel() instanceof ParameterModel).map(x$0 -> new ParameterModelInformation((DslElementModel)x$0)).forEach(i -> parametersDslMap.put(((ParameterModelInformation)i).getParameterModel().getName(), i));
            return Optional.of(parametersDslMap);
        }
        return Optional.empty();
    }

    private Optional<ValueProviderCacheId> resolveId(DslElementModel<?> containerComponent, ValueProviderModel valueProviderModel, Map<String, ParameterModelInformation> parameterModelsInformation) {
        if (containerComponent.getModel() instanceof ComponentModel) {
            return this.resolveForComponentModel(containerComponent, valueProviderModel, parameterModelsInformation);
        }
        return this.resolveForGlobalElement(containerComponent, valueProviderModel, parameterModelsInformation);
    }

    private Optional<ValueProviderCacheId> resolveForGlobalElement(DslElementModel<?> containerComponent, ValueProviderModel valueProviderModel, Map<String, ParameterModelInformation> parameterModelsInformation) {
        LinkedList<ValueProviderCacheId> parts = new LinkedList<ValueProviderCacheId>();
        parts.add(this.resolveValueProviderId(valueProviderModel));
        parts.addAll(this.resolveActingParameterIds(valueProviderModel, parameterModelsInformation));
        String id = this.resolveDslTag(containerComponent).orElse(DslElementIdHelper.getSourceElementName(containerComponent));
        return Optional.of(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)id).withHashValueFrom((Object)id).containing(parts)));
    }

    private Optional<ValueProviderCacheId> resolveForComponentModel(DslElementModel<?> containerComponent, ValueProviderModel valueProviderModel, Map<String, ParameterModelInformation> parameterModelsInformation) {
        LinkedList<ValueProviderCacheId> parts = new LinkedList<ValueProviderCacheId>();
        parts.add(this.resolveValueProviderId(valueProviderModel));
        parts.addAll(this.resolveActingParameterIds(valueProviderModel, parameterModelsInformation));
        parts.addAll(this.resolveIdForInjectedElements(containerComponent, valueProviderModel));
        String id = this.resolveDslTag(containerComponent).orElse(DslElementIdHelper.getSourceElementName(containerComponent));
        return Optional.of(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)id).withHashValueFrom((Object)id).containing(parts)));
    }

    private List<ValueProviderCacheId> resolveIdForInjectedElements(DslElementModel<?> containerComponent, ValueProviderModel valueProviderModel) {
        if (!valueProviderModel.requiresConfiguration() && !valueProviderModel.requiresConnection()) {
            return Collections.emptyList();
        }
        LinkedList<ValueProviderCacheId> injectableIds = new LinkedList<ValueProviderCacheId>();
        Optional configDslElementModel = DslElementIdHelper.resolveConfigName(containerComponent).flatMap(config -> this.locator.get(Location.builder().globalName(config).build()));
        if (configDslElementModel.isPresent() && ((DslElementModel)configDslElementModel.get()).getModel() instanceof ConfigurationModel) {
            if (valueProviderModel.requiresConfiguration()) {
                this.resolveIdForInjectedElement((DslElementModel)configDslElementModel.get()).ifPresent(id -> injectableIds.add(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)"config: ").containing(new ValueProviderCacheId[]{id}))));
            }
            if (valueProviderModel.requiresConnection()) {
                ((DslElementModel)configDslElementModel.get()).getContainedElements().stream().filter(nested -> nested.getModel() instanceof ConnectionProviderModel).forEach(connectionProvider -> this.resolveIdForInjectedElement((DslElementModel<?>)connectionProvider).ifPresent(id -> injectableIds.add(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)"connection: ").containing(new ValueProviderCacheId[]{id})))));
            }
        }
        return injectableIds;
    }

    private Optional<ValueProviderCacheId> resolveIdForInjectedElement(DslElementModel<?> injectedElement) {
        if (!(injectedElement.getModel() instanceof EnrichableModel)) {
            return Optional.empty();
        }
        LinkedList parts = new LinkedList();
        List parametersRequiredForMetadata = ((EnrichableModel)injectedElement.getModel()).getModelProperty(RequiredForMetadataModelProperty.class).map(RequiredForMetadataModelProperty::getRequiredParameters).orElse(Collections.emptyList());
        this.resolveParametersInformation(injectedElement).ifPresent(pi -> parametersRequiredForMetadata.forEach(requiredParameter -> {
            if (pi.containsKey(requiredParameter)) {
                ParameterModelInformation parameterInfo = (ParameterModelInformation)pi.get(requiredParameter);
                this.resolveParameterId(parameterInfo.getParameterDslElementModel()).ifPresent(parts::add);
            }
        }));
        if (parts.isEmpty()) {
            return Optional.empty();
        }
        String sourceElementName = DslElementIdHelper.sourceElementNameFromSimpleValue(injectedElement);
        return Optional.of(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)sourceElementName).withHashValueFrom((Object)sourceElementName).containing(parts)));
    }

    private ValueProviderCacheId resolveValueProviderId(ValueProviderModel valueProviderModel) {
        return ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)("valueProvider: " + valueProviderModel.getProviderName())).withHashValueFrom((Object)valueProviderModel.getProviderName()));
    }

    private List<ValueProviderCacheId> resolveActingParameterIds(ValueProviderModel valueProviderModel, Map<String, ParameterModelInformation> parameterModelsInformation) {
        LinkedList<ValueProviderCacheId> parts = new LinkedList<ValueProviderCacheId>();
        valueProviderModel.getActingParameters().forEach(ap -> {
            if (parameterModelsInformation.containsKey(ap)) {
                this.resolveParameterId(((ParameterModelInformation)parameterModelsInformation.get(ap)).getParameterDslElementModel()).ifPresent(parts::add);
            }
        });
        return parts;
    }

    private Optional<ValueProviderCacheId> resolveParameterId(DslElementModel<?> parameterModel) {
        return parameterModel.getValue().map(v -> ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId((ValueProviderCacheId.ValueProviderCacheIdBuilder)ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName((String)("param:" + DslElementIdHelper.sourceElementNameFromSimpleValue(parameterModel))).withHashValueFrom(v)));
    }

    private Optional<String> resolveDslTag(DslElementModel<?> elementModel) {
        return elementModel.getIdentifier().map(Object::toString);
    }

    private class ParameterModelInformation {
        private ParameterModel parameterModel;
        private DslElementModel<?> parameterDslElementModel;

        private ParameterModelInformation(DslElementModel<?> dslElementModel) {
            Preconditions.checkArgument((boolean)(dslElementModel.getModel() instanceof ParameterModel), (String)"A ParameterModel is expected");
            this.parameterModel = (ParameterModel)dslElementModel.getModel();
            this.parameterDslElementModel = dslElementModel;
        }

        private ParameterModel getParameterModel() {
            return this.parameterModel;
        }

        private DslElementModel<?> getParameterDslElementModel() {
            return this.parameterDslElementModel;
        }
    }
}

