/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.xml;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.config.internal.dsl.xml.StaticXmlNamespaceInfo;
import org.mule.runtime.config.internal.dsl.xml.StaticXmlNamespaceInfoProvider;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;

public class XmlNamespaceInfoProviderSupplier {
    public static List<XmlNamespaceInfoProvider> createFromExtensionModels(Set<ExtensionModel> extensionModels, Optional<Function<ClassLoader, List<XmlNamespaceInfoProvider>>> xmlNamespaceInfoProvidersSupplierOptional) {
        Function<ClassLoader, List<XmlNamespaceInfoProvider>> supplier = xmlNamespaceInfoProvidersSupplierOptional.orElse(classLoader -> {
            Iterator<XmlNamespaceInfoProvider> iterator = ServiceLoader.load(XmlNamespaceInfoProvider.class, classLoader).iterator();
            if (iterator.hasNext()) {
                return ImmutableList.copyOf(iterator);
            }
            return Collections.emptyList();
        });
        ImmutableList xmlNamespaceInfoProviders = ImmutableList.builder().add((Object)XmlNamespaceInfoProviderSupplier.createStaticNamespaceInfoProviders(extensionModels)).addAll(XmlNamespaceInfoProviderSupplier.discoverRuntimeXmlNamespaceInfoProvider(supplier)).addAll(XmlNamespaceInfoProviderSupplier.discoverArtifactNamespaceInfoProvider(supplier)).build();
        return xmlNamespaceInfoProviders;
    }

    public static List<XmlNamespaceInfoProvider> createFromPluginClassloaders(Function<ClassLoader, List<XmlNamespaceInfoProvider>> xmlNamespaceInfoProvidersSupplier, List<ClassLoader> pluginsClassLoaders) {
        ImmutableList.Builder namespaceInfoProvidersBuilder = ImmutableList.builder();
        namespaceInfoProvidersBuilder.addAll((Iterable)xmlNamespaceInfoProvidersSupplier.apply(Thread.currentThread().getContextClassLoader()));
        for (ClassLoader pluginClassLoader : pluginsClassLoaders) {
            namespaceInfoProvidersBuilder.addAll((Iterable)xmlNamespaceInfoProvidersSupplier.apply(pluginClassLoader));
        }
        return namespaceInfoProvidersBuilder.build();
    }

    private static List<XmlNamespaceInfoProvider> discoverArtifactNamespaceInfoProvider(Function<ClassLoader, List<XmlNamespaceInfoProvider>> xmlNamespaceInfoProvidersSupplier) {
        return xmlNamespaceInfoProvidersSupplier.apply(Thread.currentThread().getContextClassLoader());
    }

    private static List<XmlNamespaceInfoProvider> discoverRuntimeXmlNamespaceInfoProvider(Function<ClassLoader, List<XmlNamespaceInfoProvider>> xmlNamespaceInfoProvidersSupplier) {
        return xmlNamespaceInfoProvidersSupplier.apply(XmlNamespaceInfoProvider.class.getClassLoader());
    }

    private static XmlNamespaceInfoProvider createStaticNamespaceInfoProviders(Set<ExtensionModel> extensionModels) {
        List extensionNamespaces = (List)extensionModels.stream().map(ext -> new StaticXmlNamespaceInfo(ext.getXmlDslModel().getNamespace(), ext.getXmlDslModel().getPrefix())).collect(Collectors.toImmutableList());
        return new StaticXmlNamespaceInfoProvider(extensionNamespaces);
    }
}

