/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.List;
import java.util.Map;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.internal.dsl.BeanDefinitionPostProcessor;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CommonComponentBeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CreateComponentBeanDefinitionRequest;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.dsl.config.RuntimeConfigurationException;
import org.mule.runtime.module.extension.internal.component.AnnotatedObjectInvocationHandler;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

class ObjectBeanDefinitionCreator
extends BeanDefinitionCreator<CreateComponentBeanDefinitionRequest> {
    static final String REF_PARAMETER = "ref";
    static final String CLASS_PARAMETER = "class";

    ObjectBeanDefinitionCreator() {
    }

    @Override
    boolean handleRequest(Map<ComponentAst, SpringComponentModel> springComponentModels, CreateComponentBeanDefinitionRequest createBeanDefinitionRequest) {
        String classParameterValue;
        ComponentAst component = createBeanDefinitionRequest.getComponent();
        if (component == null || !component.getIdentifier().equals(ApplicationModel.OBJECT_IDENTIFIER)) {
            return false;
        }
        ComponentParameterAst refParameterAst = component.getParameter("General", REF_PARAMETER);
        ComponentParameterAst classParameterAst = component.getParameter("General", CLASS_PARAMETER);
        String refParameterValue = refParameterAst != null ? refParameterAst.getResolvedRawValue() : null;
        String string = classParameterValue = classParameterAst != null ? classParameterAst.getResolvedRawValue() : null;
        if (refParameterValue != null && classParameterValue != null) {
            throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Object cannot contain both '%s' and '%s' parameters. Offending resource is '%s'", REF_PARAMETER, CLASS_PARAMETER, component.getLocation())));
        }
        if (refParameterValue == null && classParameterValue == null) {
            throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Object must contain '%s' or '%s' parameter. Offending resource is '%s'", REF_PARAMETER, CLASS_PARAMETER, component.getLocation())));
        }
        if (refParameterValue != null) {
            createBeanDefinitionRequest.getSpringComponentModel().setBeanReference((BeanReference)new RuntimeBeanReference(refParameterValue));
        }
        if (classParameterValue != null) {
            BeanDefinitionBuilder beanDefinitionBuilder;
            Class<?> classParameter;
            try {
                classParameter = Class.forName(classParameterValue, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), (Throwable)e);
            }
            try {
                beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)AnnotatedObjectInvocationHandler.addAnnotationsToClass(classParameter));
            }
            catch (LinkageError e) {
                throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Exception adding annotations to class '%s'", classParameter.getName())), (Throwable)e);
            }
            this.processMuleProperties(component, beanDefinitionBuilder, null);
            createBeanDefinitionRequest.getSpringComponentModel().setBeanDefinition((BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        }
        return true;
    }

    private void processMuleProperties(ComponentAst component, BeanDefinitionBuilder beanDefinitionBuilder, BeanDefinitionPostProcessor beanDefinitionPostProcessor) {
        List properties = (List)component.getParameter("General", "property").getValue().getRight();
        if (properties != null) {
            CommonComponentBeanDefinitionCreator.doProcessMuleProperties(beanDefinitionBuilder, properties.stream());
        }
    }
}

