/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.config.internal.MuleArtifactContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.privileged.processor.AnnotatedProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.routing.RoutePathNotFoundException;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FlowRefFactoryBean
extends AbstractComponentFactory<Processor>
implements ApplicationContextAware,
MuleContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowRefFactoryBean.class);
    private String refName;
    private ApplicationContext applicationContext;
    private MuleContext muleContext;

    public void setName(String name) {
        this.refName = name;
    }

    public Processor doGetObject() throws Exception {
        if (this.refName.isEmpty()) {
            throw new IllegalArgumentException("flow-ref name is empty");
        }
        return new FlowRefMessageProcessor();
    }

    protected Processor getReferencedFlow(String name, FlowRefMessageProcessor flowRefMessageProcessor) throws MuleException {
        if (name == null) {
            throw new RoutePathNotFoundException(I18nMessageFactory.createStaticMessage((String)"flow-ref name expression returned 'null'"), (Processor)flowRefMessageProcessor);
        }
        Processor referencedFlow = this.getReferencedProcessor(name);
        if (referencedFlow == null) {
            throw new RoutePathNotFoundException(I18nMessageFactory.createStaticMessage((String)"No flow/sub-flow with name '%s' found", (Object[])new Object[]{name}), (Processor)flowRefMessageProcessor);
        }
        if (!(referencedFlow instanceof Flow)) {
            HashMap<QName, String> annotations = new HashMap<QName, String>(((Component)referencedFlow).getAnnotations());
            annotations.put(ROOT_CONTAINER_NAME_KEY, this.getRootContainerLocation().toString());
            ((Component)referencedFlow).setAnnotations(annotations);
            if (referencedFlow instanceof Initialisable) {
                LifecycleUtils.initialiseIfNeeded((Object)referencedFlow, (MuleContext)this.muleContext);
                if (referencedFlow instanceof MessageProcessorChain) {
                    for (Processor processor : ((MessageProcessorChain)referencedFlow).getMessageProcessors()) {
                        LifecycleUtils.setMuleContextIfNeeded((Object)processor, (MuleContext)this.muleContext);
                    }
                }
            }
            LifecycleUtils.startIfNeeded((Object)referencedFlow);
        }
        return referencedFlow;
    }

    private Processor getReferencedProcessor(String name) {
        if (this.applicationContext instanceof MuleArtifactContext) {
            MuleArtifactContext muleArtifactContext = (MuleArtifactContext)this.applicationContext;
            try {
                if (muleArtifactContext.getBeanFactory().getBeanDefinition(name).isPrototype()) {
                    muleArtifactContext.getPrototypeBeanWithRootContainer(name, this.getRootContainerLocation().toString());
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                return null;
            }
        }
        return (Processor)this.applicationContext.getBean(name);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    private class FlowRefMessageProcessor
    extends AbstractComponent
    implements AnnotatedProcessor,
    Stoppable,
    Disposable {
        private LoadingCache<String, Processor> cache;
        private boolean isExpression;

        public FlowRefMessageProcessor() {
            this.cache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<String, Processor>(){

                public Processor load(String key) throws Exception {
                    return FlowRefFactoryBean.this.getReferencedFlow(key, FlowRefMessageProcessor.this);
                }
            });
            this.isExpression = FlowRefFactoryBean.this.muleContext.getExpressionManager().isExpression(FlowRefFactoryBean.this.refName);
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
        }

        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return Flux.from(publisher).flatMap(event -> {
                Processor referencedProcessor;
                try {
                    referencedProcessor = this.resolveReferencedProcessor((CoreEvent)event);
                }
                catch (MuleException e) {
                    return Flux.error((Throwable)e);
                }
                if (referencedProcessor instanceof Flow) {
                    return Flux.just((Object)event).flatMap(request -> Mono.from((Publisher)MessageProcessors.processWithChildContext((CoreEvent)request, (ReactiveProcessor)referencedProcessor, Optional.ofNullable(FlowRefFactoryBean.this.getLocation()), (FlowExceptionHandler)((Flow)referencedProcessor).getExceptionListener())));
                }
                return Flux.just((Object)event).transform((Function)referencedProcessor);
            });
        }

        protected Processor resolveReferencedProcessor(CoreEvent event) throws MuleException {
            String flowName = this.isExpression ? FlowRefFactoryBean.this.muleContext.getExpressionManager().parse(FlowRefFactoryBean.this.refName, event, this.getLocation()) : FlowRefFactoryBean.this.refName;
            try {
                return (Processor)this.cache.getUnchecked((Object)flowName);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof MuleRuntimeException) {
                    throw (MuleRuntimeException)e.getCause();
                }
                if (e.getCause() instanceof MuleException) {
                    throw (MuleException)e.getCause();
                }
                throw e;
            }
        }

        public ComponentLocation getLocation() {
            return FlowRefFactoryBean.this.getLocation();
        }

        public void stop() throws MuleException {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.stopIfNeeded((Object)p);
            }
        }

        public void dispose() {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.disposeIfNeeded((Object)p, (Logger)LOGGER);
            }
            this.cache.invalidateAll();
            this.cache.cleanUp();
        }
    }
}

