/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal;

import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.config.spring.internal.LazyMuleArtifactContext;
import org.mule.runtime.config.spring.internal.dsl.model.NoSuchComponentModelException;
import org.mule.runtime.core.internal.value.MuleValueProviderServiceUtility;

public class LazyValueProviderService
implements ValueProviderService,
Initialisable {
    public static final String NON_LAZY_VALUE_PROVIDER_SERVICE = "_muleNonLazyValueProviderService";
    private final Supplier<ValueProviderService> valueProviderServiceSupplier;
    private LazyMuleArtifactContext lazyMuleArtifactContext;
    @Inject
    @Named(value="_muleNonLazyValueProviderService")
    private ValueProviderService providerService;

    LazyValueProviderService(LazyMuleArtifactContext artifactContext, Supplier<ValueProviderService> valueProviderServiceSupplier) {
        this.lazyMuleArtifactContext = artifactContext;
        this.valueProviderServiceSupplier = valueProviderServiceSupplier;
    }

    public ValueResult getValues(Location location, String providerName) {
        return this.initializeComponent(this.locationWithOutConnection(location)).orElseGet(() -> this.providerService.getValues(location, providerName));
    }

    private Optional<ValueResult> initializeComponent(Location location) {
        try {
            this.lazyMuleArtifactContext.initializeComponent(location);
        }
        catch (Exception e) {
            Throwable rootException = ExceptionHelper.getRootException((Throwable)e);
            if (rootException instanceof NoSuchComponentModelException) {
                return Optional.of(ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)e).withFailureCode("INVALID_LOCATION").withMessage(String.format("Unable to resolve values. No component was found in the given location [%s]", location)).build()));
            }
            return Optional.of(ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)e).withMessage("Unknown error occurred trying to resolve values. " + e.getMessage()).withFailureCode("UNKNOWN").build()));
        }
        return Optional.empty();
    }

    private Location locationWithOutConnection(Location location) {
        return MuleValueProviderServiceUtility.isConnection((Location)location) ? MuleValueProviderServiceUtility.deleteLastPartFromLocation((Location)location) : location;
    }

    public void initialise() throws InitialisationException {
        this.providerService = this.valueProviderServiceSupplier.get();
    }
}

