/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.spring;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import sun.misc.CompoundEnumeration;

class CompositeClassLoader
extends ClassLoader {
    private List<ClassLoader> delegates = new ArrayList<ClassLoader>();

    CompositeClassLoader(ClassLoader first, ClassLoader ... others) {
        this.delegates.add(first);
        this.delegates.addAll(Arrays.asList(others));
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassNotFoundException firstException = null;
        for (ClassLoader classLoader : this.delegates) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                firstException = e;
            }
        }
        throw firstException;
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classLoader : this.delegates) {
            URL resource = classLoader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader classLoader : this.delegates) {
            InputStream resourceAsStream = classLoader.getResourceAsStream(name);
            if (resourceAsStream == null) continue;
            return resourceAsStream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[this.delegates.size()];
        int i = 0;
        for (ClassLoader classLoader : this.delegates) {
            tmp[i++] = classLoader.getResources(name);
        }
        return new CompoundEnumeration(tmp);
    }

    static {
        CompositeClassLoader.registerAsParallelCapable();
    }
}

