/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;

public class ObjectTypeVisitor
implements TypeDefinitionVisitor {
    public static final Class<ArrayList> DEFAULT_COLLECTION_TYPE = ArrayList.class;
    private static final Class<HashMap> DEFAULT_MAP_TYPE = HashMap.class;
    private static final Class<HashSet> DEFAULT_SET_CLASS = HashSet.class;
    private final ComponentModel componentModel;
    private Class<?> type;
    private Optional<TypeDefinition.MapEntryType> mapEntryType = Optional.empty();

    public ObjectTypeVisitor(ComponentModel componentModel) {
        this.componentModel = componentModel;
    }

    public void onType(Class<?> type) {
        this.type = this.resolveType(type);
    }

    private Class<?> resolveType(Class<?> type) {
        if (Collection.class.equals(type) || List.class.equals(type)) {
            return DEFAULT_COLLECTION_TYPE;
        }
        if (Set.class.equals(type)) {
            return DEFAULT_SET_CLASS;
        }
        if (Map.class.equals(type)) {
            return DEFAULT_MAP_TYPE;
        }
        return type;
    }

    public void onConfigurationAttribute(String attributeName, Class<?> enforcedClass) {
        try {
            this.type = ClassUtils.getClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)this.componentModel.getParameters().get(attributeName));
            if (!enforcedClass.isAssignableFrom(this.type)) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Class definition for type %s on element %s is not the same nor inherits from %s", (Object[])new Object[]{this.componentModel.getParameters().get(attributeName), this.componentModel.getIdentifier(), enforcedClass.getName()}));
            }
        }
        catch (ClassNotFoundException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error while trying to locate Class definition for type %s on element %s", (Object[])new Object[]{this.componentModel.getParameters().get(attributeName), this.componentModel.getIdentifier()}), (Throwable)e);
        }
    }

    public void onMapType(TypeDefinition.MapEntryType mapEntryType) {
        this.type = mapEntryType.getClass();
        this.mapEntryType = Optional.of(new TypeDefinition.MapEntryType(this.resolveType(mapEntryType.getKeyType()), this.resolveType(mapEntryType.getValueType())));
    }

    public Class<?> getType() {
        return this.type;
    }

    public Optional<TypeDefinition.MapEntryType> getMapEntryType() {
        return this.mapEntryType;
    }
}

