/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.config.spring.internal.CompositeOptionalObjectsController;
import org.mule.runtime.config.spring.internal.DefaultOptionalObjectsController;
import org.mule.runtime.config.spring.internal.LazyMuleArtifactContext;
import org.mule.runtime.config.spring.internal.MuleArtifactContext;
import org.mule.runtime.config.spring.internal.OptionalObjectsController;
import org.mule.runtime.config.spring.internal.SpringRegistry;
import org.mule.runtime.config.spring.internal.artifact.SpringArtifactContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigResource;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.ParentMuleContextAwareConfigurationBuilder;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.registry.Registry;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringXmlConfigurationBuilder
extends AbstractResourceConfigurationBuilder
implements ParentMuleContextAwareConfigurationBuilder {
    private ArtifactDeclaration artifactDeclaration = new ArtifactDeclaration();
    private boolean enableLazyInit = false;
    protected boolean useDefaultConfigResource = true;
    protected boolean useMinimalConfigResource = false;
    private SpringRegistry registry;
    private ApplicationContext domainContext;
    private ApplicationContext parentContext;
    private MuleArtifactContext muleArtifactContext;
    private ArtifactType artifactType;

    public SpringXmlConfigurationBuilder(String[] configResources, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInit) throws ConfigurationException {
        super(configResources, artifactProperties);
        this.artifactType = artifactType;
        this.enableLazyInit = enableLazyInit;
    }

    public SpringXmlConfigurationBuilder(String configResources, Map<String, String> artifactProperties, ArtifactType artifactType) throws ConfigurationException {
        this(new String[]{configResources}, artifactProperties, artifactType, false);
    }

    public SpringXmlConfigurationBuilder(ConfigResource[] configResources, Map<String, String> artifactProperties, ArtifactType artifactType) {
        super(configResources, artifactProperties);
        this.artifactType = artifactType;
    }

    public SpringXmlConfigurationBuilder(String configResource) throws ConfigurationException {
        this(configResource, Collections.emptyMap(), ArtifactType.APP);
    }

    public SpringXmlConfigurationBuilder(String[] configFiles, boolean enableLazyInit) throws ConfigurationException {
        super(configFiles, Collections.emptyMap());
        this.artifactType = ArtifactType.APP;
        this.enableLazyInit = enableLazyInit;
    }

    public SpringXmlConfigurationBuilder(String[] configurationFiles, ArtifactDeclaration artifactDeclaration, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInitialisation) throws ConfigurationException {
        this(configurationFiles, artifactProperties, artifactType, enableLazyInitialisation);
        this.artifactDeclaration = artifactDeclaration;
        this.artifactType = ArtifactType.APP;
    }

    public static ConfigurationBuilder createConfigurationBuilder(String[] configResources, MuleContext domainContext, boolean lazyInit) throws ConfigurationException {
        SpringXmlConfigurationBuilder springXmlConfigurationBuilder = new SpringXmlConfigurationBuilder(configResources, Collections.emptyMap(), ArtifactType.APP, lazyInit);
        if (domainContext != null) {
            springXmlConfigurationBuilder.setParentContext(domainContext);
        }
        return springXmlConfigurationBuilder;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        this.muleArtifactContext = this.createApplicationContext(muleContext);
        this.createSpringRegistry(muleContext, (ApplicationContext)this.muleArtifactContext);
    }

    protected void addResources(List<ConfigResource> allResources) {
    }

    public void unconfigure(MuleContext muleContext) {
        this.registry.dispose();
        if (muleContext != null) {
            muleContext.removeRegistry((Registry)this.registry);
        }
        this.registry = null;
        this.configured = false;
    }

    private MuleArtifactContext createApplicationContext(MuleContext muleContext) throws Exception {
        ApplicationContext parentApplicationContext;
        OptionalObjectsController applicationObjectcontroller = new DefaultOptionalObjectsController();
        OptionalObjectsController parentObjectController = null;
        ApplicationContext applicationContext = parentApplicationContext = this.parentContext != null ? this.parentContext : this.domainContext;
        if (parentApplicationContext instanceof MuleArtifactContext) {
            parentObjectController = ((MuleArtifactContext)parentApplicationContext).getOptionalObjectsController();
        }
        if (parentObjectController != null) {
            applicationObjectcontroller = new CompositeOptionalObjectsController(applicationObjectcontroller, parentObjectController);
        }
        MuleArtifactContext muleArtifactContext = this.doCreateApplicationContext(muleContext, this.artifactDeclaration, applicationObjectcontroller);
        this.serviceConfigurators.forEach(serviceConfigurator -> serviceConfigurator.configure(muleContext.getCustomizationService()));
        return muleArtifactContext;
    }

    private MuleArtifactContext doCreateApplicationContext(MuleContext muleContext, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController) {
        if (this.enableLazyInit) {
            return new LazyMuleArtifactContext(muleContext, this.resolveArtifactConfigResources(), artifactDeclaration, optionalObjectsController, this.getArtifactProperties(), this.artifactType, MuleApplicationClassLoader.resolveContextArtifactPluginClassLoaders(), this.resolveParentConfigurationProperties());
        }
        return new MuleArtifactContext(muleContext, this.resolveArtifactConfigResources(), artifactDeclaration, optionalObjectsController, this.getArtifactProperties(), this.artifactType, MuleApplicationClassLoader.resolveContextArtifactPluginClassLoaders(), this.resolveParentConfigurationProperties());
    }

    protected ConfigResource[] resolveArtifactConfigResources() {
        return this.artifactConfigResources;
    }

    protected Optional<ConfigurationProperties> resolveParentConfigurationProperties() {
        ApplicationContext parentApplicationContext = this.parentContext != null ? this.parentContext : this.domainContext;
        Optional<Object> parentConfigurationProperties = Optional.empty();
        if (parentApplicationContext != null) {
            parentConfigurationProperties = Optional.of(parentApplicationContext.getBean(ConfigurationProperties.class));
        }
        return parentConfigurationProperties;
    }

    private void createSpringRegistry(MuleContext muleContext, ApplicationContext applicationContext) throws Exception {
        if (this.parentContext != null && this.domainContext != null) {
            throw new IllegalStateException("An application with a web xml context and domain resources is not supported");
        }
        if (this.parentContext != null) {
            this.createRegistryWithParentContext(muleContext, applicationContext, this.parentContext);
        } else if (this.domainContext != null) {
            this.createRegistryWithParentContext(muleContext, applicationContext, this.domainContext);
        } else {
            this.registry = new SpringRegistry(applicationContext, muleContext, this.muleArtifactContext.getDependencyResolver());
        }
        muleContext.addRegistry((Registry)this.registry);
    }

    private void createRegistryWithParentContext(MuleContext muleContext, ApplicationContext applicationContext, ApplicationContext parentContext) throws ConfigurationException {
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"Cannot set a parent context if the ApplicationContext does not implement ConfigurableApplicationContext"));
        }
        ((ConfigurableApplicationContext)applicationContext).setParent(parentContext);
        this.registry = new SpringRegistry(applicationContext, muleContext, this.muleArtifactContext.getDependencyResolver());
    }

    protected void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
        if (lifecycleManager.isPhaseComplete("start")) {
            lifecycleManager.fireLifecycle("start");
        }
    }

    public void setUseDefaultConfigResource(boolean useDefaultConfigResource) {
        this.useDefaultConfigResource = useDefaultConfigResource;
    }

    public ArtifactContext createArtifactContext() {
        return new SpringArtifactContext(this.muleArtifactContext);
    }

    public void setUseMinimalConfigResource(boolean useMinimalConfigResource) {
        this.useMinimalConfigResource = useMinimalConfigResource;
    }

    protected ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(ApplicationContext parentContext) {
        this.parentContext = parentContext;
    }

    public void setParentContext(MuleContext domainContext) {
        this.domainContext = (ApplicationContext)domainContext.getRegistry().get("springApplicationContext");
    }
}

