/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.config.spring.factories.processor.MessageProcessorChainFactoryBean;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.processor.MessageProcessorChainBuilder;
import org.mule.runtime.core.internal.processor.chain.ModuleOperationMessageProcessorChainBuilder;

public class ModuleOperationMessageProcessorChainFactoryBean
extends MessageProcessorChainFactoryBean {
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<String, String> parameters = new HashMap<String, String>();
    private String moduleName;
    private String moduleOperation;
    @Inject
    private ExtensionManager extensionManager;

    @Override
    protected MessageProcessorChainBuilder getBuilderInstance() {
        Optional<ExtensionModel> extensionModel = this.extensionManager.getExtensions().stream().filter(em -> em.getXmlDslModel().getPrefix().equals(this.moduleName)).findFirst();
        if (!extensionModel.isPresent()) {
            throw new IllegalArgumentException(String.format("Could not find any extension under the name of [%s]", this.moduleName));
        }
        OperationSeeker operationSeeker = new OperationSeeker();
        operationSeeker.walk(extensionModel.get());
        if (!operationSeeker.operationModel.isPresent()) {
            throw new IllegalArgumentException(String.format("Could not find any operation under the name of [%s] for the extension [%s]", this.moduleOperation, this.moduleName));
        }
        ModuleOperationMessageProcessorChainBuilder builder = new ModuleOperationMessageProcessorChainBuilder(this.properties, this.parameters, extensionModel.get(), operationSeeker.operationModel.get(), (ExpressionManager)this.muleContext.getExpressionManager());
        return builder;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setModuleOperation(String moduleOperation) {
        this.moduleOperation = moduleOperation;
    }

    private class OperationSeeker
    extends IdempotentExtensionWalker {
        Optional<OperationModel> operationModel = Optional.empty();

        private OperationSeeker() {
        }

        protected void onOperation(OperationModel operationModel) {
            if (operationModel.getName().equals(ModuleOperationMessageProcessorChainFactoryBean.this.moduleOperation)) {
                this.operationModel = Optional.of(operationModel);
                this.stop();
            }
        }
    }
}

