/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.internal.MuleCustomEntityResolver;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModuleDelegatingEntityResolver
implements EntityResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleDelegatingEntityResolver.class);
    private final Set<ExtensionModel> extensions;
    private final EntityResolver springEntityResolver;
    private final EntityResolver muleEntityResolver;
    private Map<String, String> customSchemaMappings;
    private Optional<ExtensionSchemaGenerator> extensionSchemaFactory;
    private Map<String, Boolean> checkedEntities;

    public ModuleDelegatingEntityResolver(Set<ExtensionModel> extensions) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.muleEntityResolver = new MuleCustomEntityResolver(classLoader);
        this.springEntityResolver = new DelegatingEntityResolver(classLoader);
        this.extensions = extensions;
        this.checkedEntities = new HashMap<String, Boolean>();
        SpiServiceRegistry spiServiceRegistry = new SpiServiceRegistry();
        Collection schemaResourceFactories = spiServiceRegistry.lookupProviders(ExtensionSchemaGenerator.class, this.getClass().getClassLoader());
        if (schemaResourceFactories.isEmpty()) {
            this.extensionSchemaFactory = Optional.empty();
        } else if (schemaResourceFactories.size() == 1) {
            this.extensionSchemaFactory = Optional.of(schemaResourceFactories.iterator().next());
        } else {
            throw new IllegalArgumentException(String.format("There are '%s' providers for '%s' when there must be 1 or zero.", schemaResourceFactories.size(), ExtensionSchemaGenerator.class.getName()));
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Looking schema for public identifier(publicId): '%s', system identifier(systemId): '%s'", publicId == null ? "" : publicId, systemId));
        }
        Boolean useDeprecated = this.springEntityResolver.resolveEntity(publicId, "http://www.mulesoft.org/schema/mule/core/current/mule-core-deprecated.xsd") != null;
        if (systemId.equals("http://www.mulesoft.org/schema/mule/core/current/mule.xsd")) {
            systemId = useDeprecated != false ? "http://www.mulesoft.org/schema/mule/core/current/mule-core-deprecated.xsd" : "http://www.mulesoft.org/schema/mule/core/current/mule-core.xsd";
        }
        if ((inputSource = this.muleEntityResolver.resolveEntity(publicId, systemId)) == null) {
            inputSource = this.generateFromExtensions(publicId, systemId);
        }
        if (inputSource == null) {
            inputSource = this.springEntityResolver.resolveEntity(publicId, systemId);
        }
        if (inputSource == null) {
            if (this.checkedEntities.get(systemId) != null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Can't resolve %s %s", (Object[])new Object[]{publicId == null ? "" : publicId, systemId}));
            }
            this.checkedEntities.put(systemId, true);
        }
        return inputSource;
    }

    private InputSource generateFromExtensions(String publicId, String systemId) {
        Optional<ExtensionModel> extensionModel;
        InputSource inputSource = null;
        if (this.extensionSchemaFactory.isPresent() && (extensionModel = this.extensions.stream().filter(em -> systemId.equals(em.getXmlDslModel().getSchemaLocation())).findAny()).isPresent()) {
            InputStream schema = this.getSchemaFromExtension(extensionModel.get());
            inputSource = new InputSource(schema);
            inputSource.setPublicId(publicId);
            inputSource.setSystemId(systemId);
        }
        return inputSource;
    }

    private InputStream getSchemaFromExtension(ExtensionModel extensionModel) {
        String generatedResource = this.extensionSchemaFactory.map(f -> f.generate(extensionModel, DslResolvingContext.getDefault(this.extensions))).orElseThrow(() -> new IllegalStateException("There were no schema generators available when trying to work with the extension '" + extensionModel.getName() + "'"));
        return new ByteArrayInputStream(generatedResource.getBytes());
    }
}

