/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.specific;

import org.mule.runtime.config.spring.parsers.generic.NamedDefinitionParser;
import org.mule.runtime.config.spring.util.ProcessingStrategyParserUtils;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ConfigurationDefinitionParser
extends NamedDefinitionParser {
    public static final String DEFAULT_ERROR_HANDLER_ATTRIBUTE = "defaultErrorHandler-ref";
    private static final String DEFAULT_OBJECT_SERIALIZER_ATTRIBUTE = "defaultObjectSerializer-ref";

    public ConfigurationDefinitionParser() {
        super("_muleConfiguration");
        this.addIgnored(DEFAULT_ERROR_HANDLER_ATTRIBUTE);
        this.singleton = true;
    }

    @Override
    protected Class getBeanClass(Element element) {
        return MuleConfiguration.class;
    }

    @Override
    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        this.parseExceptionStrategy(element, builder);
        this.parseObjectSerializer(element, builder);
        ProcessingStrategyParserUtils.configureProcessingStrategy(element, builder, "processingStrategyFactory");
        super.doParse(element, context, builder);
    }

    private void parseExceptionStrategy(Element element, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(DEFAULT_ERROR_HANDLER_ATTRIBUTE)) {
            builder.addPropertyValue("defaultErrorHandlerName", (Object)element.getAttribute(DEFAULT_ERROR_HANDLER_ATTRIBUTE));
        }
    }

    private void parseObjectSerializer(Element element, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(DEFAULT_OBJECT_SERIALIZER_ATTRIBUTE)) {
            builder.addPropertyReference("defaultObjectSerializer", element.getAttribute(DEFAULT_OBJECT_SERIALIZER_ATTRIBUTE));
        }
    }

    @Override
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return "_muleConfiguration";
    }
}

