/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.processors;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.PropertyFactory;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class PropertyPlaceholderProcessor
extends PropertyPlaceholderConfigurer
implements MuleContextAware {
    private MuleContext muleContext;
    private Map factories = new HashMap();

    protected Properties mergeProperties() throws IOException {
        RegistryProperties props = new RegistryProperties();
        props.putAll((Map<?, ?>)super.mergeProperties());
        props.put("mule.working.dir", this.muleContext.getConfiguration().getWorkingDirectory());
        if (this.factories != null) {
            for (Map.Entry entry : this.factories.entrySet()) {
                if (entry.getKey() == null) {
                    throw new NullPointerException(CoreMessages.objectIsNull((String)"Factories.Key").getMessage());
                }
                if (entry.getValue() == null) {
                    throw new NullPointerException(CoreMessages.objectIsNull((String)"Factories.Value").getMessage());
                }
                try {
                    props.put(entry.getKey(), ((PropertyFactory)entry.getValue()).create((Map)props));
                }
                catch (Exception e) {
                    throw new IOException("Failed to invoke PropertyFactory: " + entry.getValue() + ". Error is: " + e.toString());
                }
            }
        }
        return props;
    }

    public Map getFactories() {
        return this.factories;
    }

    public void setFactories(Map factories) {
        this.factories = factories;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    private class RegistryProperties
    extends Properties {
        private RegistryProperties() {
        }

        @Override
        public String getProperty(String key) {
            Object oval = super.get(key);
            if (oval == null) {
                oval = PropertyPlaceholderProcessor.this.muleContext.getRegistry().lookupObject(key);
            }
            String sval = oval instanceof String ? (String)oval : null;
            return sval == null && this.defaults != null ? this.defaults.getProperty(key) : sval;
        }
    }
}

