/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.artifact;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfigurationLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.service.internal.artifact.LibraryByJavaVersion;

public class LibFolderClassLoaderConfigurationLoader
implements ClassLoaderConfigurationLoader {
    public static final String LIB_FOLDER = "lib";
    private static final Set<ArtifactType> supportedTypes = new HashSet<ArtifactType>(Arrays.asList(ArtifactType.SERVICE, ArtifactType.SERVER_PLUGIN));
    private static final int JVM_SPECIFICATION_VERSION = Integer.parseInt(SystemUtils.JAVA_VM_SPECIFICATION_VERSION.split("\\.")[0]);
    private static final String JAR_FILE = "*.jar";
    private static final FilenameFilter JAR_FILE_FILTER = WildcardFileFilter.builder().setWildcards(new String[]{"*.jar"}).get();

    public String getId() {
        return "service";
    }

    public ClassLoaderConfiguration load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        if (artifactFile == null || !artifactFile.exists()) {
            throw new IllegalArgumentException("Service folder does not exists: " + (artifactFile != null ? artifactFile.getName() : null));
        }
        ClassLoaderConfiguration.ClassLoaderConfigurationBuilder classLoaderConfigurationBuilder = new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder();
        classLoaderConfigurationBuilder.containing(this.getUrl(artifactFile));
        classLoaderConfigurationBuilder.containing(this.getServiceUrls(artifactFile));
        classLoaderConfigurationBuilder.containing(this.getServiceUrlsForJavaVersion(artifactFile));
        return classLoaderConfigurationBuilder.build();
    }

    private URL getUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an exception obtaining the URL for the service: [%s]", file.getAbsolutePath()), (Throwable)e);
        }
    }

    private List<URL> getServiceUrls(File rootFolder) {
        LinkedList<URL> urls = new LinkedList<URL>();
        this.loadJarsFromFolder(urls, new File(rootFolder, LIB_FOLDER));
        return urls;
    }

    private List<URL> getServiceUrlsForJavaVersion(File rootFolder) {
        LinkedList<URL> urls = new LinkedList<URL>();
        File libJavaVersionsDir = new File(rootFolder, "lib/java-versions");
        if (libJavaVersionsDir.exists()) {
            for (File jvmDependantLib : LibraryByJavaVersion.resolveJvmDependantLibs(JVM_SPECIFICATION_VERSION, this.loadLibsByJavaVersion(libJavaVersionsDir))) {
                urls.add(this.getFileUrl(jvmDependantLib));
            }
        }
        return urls;
    }

    private Collection<LibraryByJavaVersion> loadLibsByJavaVersion(File libJavaVersionsDir) {
        HashSet<LibraryByJavaVersion> libsByJavaVersion = new HashSet<LibraryByJavaVersion>();
        for (File libJavaVersionDir : libJavaVersionsDir.listFiles()) {
            int libsJavaVersion;
            try {
                libsJavaVersion = Integer.parseInt(libJavaVersionDir.getName());
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(String.format("Could not obtain a valid Java version from the folder name: %s", libJavaVersionDir.getAbsolutePath()), e);
            }
            for (File libJavaVersionJar : libJavaVersionDir.listFiles(JAR_FILE_FILTER)) {
                libsByJavaVersion.add(new LibraryByJavaVersion(libsJavaVersion, libJavaVersionJar));
            }
        }
        return libsByJavaVersion;
    }

    private void loadJarsFromFolder(List<URL> urls, File folder) {
        File[] files;
        if (!folder.exists()) {
            return;
        }
        for (File jarFile : files = folder.listFiles(JAR_FILE_FILTER)) {
            urls.add(this.getFileUrl(jarFile));
        }
    }

    private URL getFileUrl(File jarFile) {
        try {
            return jarFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot create service class loader", e);
        }
    }

    public boolean supportsArtifactType(ArtifactType artifactType) {
        return supportedTypes.contains(artifactType);
    }
}

