/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.api.discoverer;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.deployment.meta.MuleServiceContractModel;
import org.mule.runtime.api.deployment.meta.MuleServiceModel;
import org.mule.runtime.api.deployment.persistence.MuleServiceModelJsonSerializer;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;

public class MuleServiceModelLoader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MuleServiceModel loadServiceModel(ClassLoader serviceClassLoader) {
        try (InputStream stream = serviceClassLoader.getResource("META-INF/mule-artifact/mule-artifact.json").openStream();){
            MuleServiceModel muleServiceModel = (MuleServiceModel)new MuleServiceModelJsonSerializer().deserialize(IOUtils.toString((InputStream)stream));
            return muleServiceModel;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not read extension describer on service '%s'", "a"), e);
        }
    }

    public static ServiceProvider instantiateServiceProvider(MuleServiceContractModel contractModel) throws ServiceResolutionError {
        Object reflectedObject;
        String className = contractModel.getServiceProviderClassName();
        try {
            reflectedObject = ClassUtils.instantiateClass((String)className, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new ServiceResolutionError("Unable to create service from class: " + className, e);
        }
        if (!(reflectedObject instanceof ServiceProvider)) {
            throw new ServiceResolutionError(String.format("Provided service class '%s' does not implement '%s'", className, ServiceProvider.class.getName()));
        }
        return (ServiceProvider)reflectedObject;
    }
}

