/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.mule.runtime.api.deployment.meta.MuleServiceModel;
import org.mule.runtime.api.deployment.persistence.AbstractMuleArtifactModelJsonSerializer;
import org.mule.runtime.api.deployment.persistence.MuleServiceModelJsonSerializer;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.service.LibFolderClassLoaderModelLoader;
import org.mule.runtime.module.service.ServiceDescriptor;

public class ServiceDescriptorFactory
extends AbstractArtifactDescriptorFactory<MuleServiceModel, ServiceDescriptor> {
    private static final String SERVICE_PROVIDER_CLASS_NAME = "service.className";

    ServiceDescriptorFactory(DescriptorLoaderRepository descriptorLoaderRepository) {
        super(descriptorLoaderRepository);
    }

    protected ArtifactType getArtifactType() {
        return ArtifactType.SERVICE;
    }

    public ServiceDescriptor create(File artifactFolder) throws ArtifactDescriptorCreateException {
        if (!artifactFolder.exists()) {
            throw new IllegalArgumentException("Service folder does not exists: " + artifactFolder.getAbsolutePath());
        }
        File servicePropsFile = new File(artifactFolder, "service.properties");
        if (servicePropsFile.exists()) {
            String serviceName = artifactFolder.getName();
            ServiceDescriptor descriptor = new ServiceDescriptor(serviceName);
            descriptor.setRootFolder(artifactFolder);
            Properties props = new Properties();
            try {
                props.load(new FileReader(servicePropsFile));
            }
            catch (IOException e) {
                throw new ArtifactDescriptorCreateException("Cannot read service.properties file", (Throwable)e);
            }
            descriptor.setClassLoaderModel(this.createClassLoaderModel(artifactFolder));
            descriptor.setServiceProviderClassName(props.getProperty(SERVICE_PROVIDER_CLASS_NAME));
            return descriptor;
        }
        return (ServiceDescriptor)super.create(artifactFolder);
    }

    private ClassLoaderModel createClassLoaderModel(File artifactFolder) {
        try {
            return new LibFolderClassLoaderModelLoader().load(artifactFolder, Collections.emptyMap(), ArtifactType.SERVICE);
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new IllegalStateException("Cannot load classloader model for service", e);
        }
    }

    protected void doDescriptorConfig(MuleServiceModel artifactModel, ServiceDescriptor descriptor, File artifactLocation) {
        descriptor.setServiceProviderClassName(artifactModel.getServiceProviderClassName());
    }

    protected ServiceDescriptor createArtifactDescriptor(File artifactLocation, String name) {
        return new ServiceDescriptor(name);
    }

    protected AbstractMuleArtifactModelJsonSerializer<MuleServiceModel> getMuleArtifactModelJsonSerializer() {
        return new MuleServiceModelJsonSerializer();
    }
}

